/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.time.Instant;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantDateValue;

public interface DateValue
extends DateValueStream,
LongValue {
    public Date getDate();

    public static abstract class AbstractDateValue
    implements CastingDateValue {
        @Override
        public Date getDate() {
            long val = this.getLong();
            return this.exists() ? new Date(val) : null;
        }

        @Override
        public String getString() {
            long val = this.getLong();
            return this.exists() ? Instant.ofEpochMilli(val).toString() : null;
        }

        @Override
        public Object getObject() {
            return this.getDate();
        }

        @Override
        public void streamDates(Consumer<Date> cons) {
            Date val = this.getDate();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long val = this.getLong();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public AnalyticsValue convertToConstant() {
            if (this.getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST)) {
                return new ConstantDateValue(this.getLong());
            }
            return this;
        }

        @Override
        public ExpressionComparator<Date> getObjectComparator(String expression) {
            return new ExpressionComparator<Date>(expression);
        }
    }

    public static interface CastingDateValue
    extends DateValue,
    LongValue,
    StringValue,
    ComparableValue {
    }
}

