/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;

public class SnapshotCreateTool
extends ToolBase {
    public SnapshotCreateTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "snapshot-create";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection to be snapshot.").build(), Option.builder().longOpt("snapshot-name").argName("NAME").hasArg().required(true).desc("Name of the snapshot to produce").build(), SolrCLI.OPTION_CREDENTIALS);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String snapshotName = cli.getOptionValue("snapshot-name");
        String collectionName = cli.getOptionValue("name");
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            this.createSnapshot(solrClient, collectionName, snapshotName);
        }
    }

    public void createSnapshot(SolrClient solrClient, String collectionName, String snapshotName) {
        CollectionAdminRequest.CreateSnapshot createSnapshot = new CollectionAdminRequest.CreateSnapshot(collectionName, snapshotName);
        try {
            CollectionAdminResponse resp = (CollectionAdminResponse)createSnapshot.process(solrClient);
            if (resp.getStatus() != 0) {
                throw new IllegalStateException("The CREATESNAPSHOT request failed. The status code is " + resp.getStatus());
            }
            this.echo("Successfully created snapshot with name " + snapshotName + " for collection " + collectionName);
        }
        catch (Exception e) {
            this.echo("Failed to create a snapshot with name " + snapshotName + " for collection " + collectionName + " due to following error : " + e.getLocalizedMessage());
        }
    }
}

