/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.SyncOrAsync;
import dev.ai4j.openai4j.image.GenerateImagesRequest;
import dev.ai4j.openai4j.image.GenerateImagesResponse;
import dev.ai4j.openai4j.image.ImageData;
import dev.ai4j.openai4j.image.ImageModel;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.openai.OpenAiImageModelName;
import dev.langchain4j.model.openai.spi.OpenAiImageModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OpenAiImageModel
implements dev.langchain4j.model.image.ImageModel {
    private final String modelName;
    private final String size;
    private final String quality;
    private final String style;
    private final String user;
    private final String responseFormat;
    private final OpenAiClient client;
    private final Integer maxRetries;

    public OpenAiImageModel(String baseUrl, String apiKey, String organizationId, String modelName, String size, String quality, String style, String user, String responseFormat, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Boolean withPersisting, Path persistTo, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        OpenAiClient.Builder cBuilder = OpenAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1")).openAiApiKey(apiKey).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).userAgent("langchain4j-openai").persistTo(persistTo).customHeaders(customHeaders);
        if (withPersisting != null && withPersisting.booleanValue()) {
            cBuilder.withPersisting();
        }
        this.client = cBuilder.build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.modelName = modelName;
        this.size = size;
        this.quality = quality;
        this.style = style;
        this.user = user;
        this.responseFormat = responseFormat;
    }

    public String modelName() {
        return this.modelName;
    }

    public Response<Image> generate(String prompt) {
        GenerateImagesRequest request = this.requestBuilder(prompt).build();
        GenerateImagesResponse response = (GenerateImagesResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.imagesGeneration(request), (int)this.maxRetries)).execute();
        return Response.from((Object)OpenAiImageModel.fromImageData((ImageData)response.data().get(0)));
    }

    public Response<List<Image>> generate(String prompt, int n) {
        GenerateImagesRequest request = this.requestBuilder(prompt).n(n).build();
        GenerateImagesResponse response = (GenerateImagesResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.imagesGeneration(request), (int)this.maxRetries)).execute();
        return Response.from(response.data().stream().map(OpenAiImageModel::fromImageData).collect(Collectors.toList()));
    }

    public static OpenAiImageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiImageModelBuilderFactory factory = (OpenAiImageModelBuilderFactory)iterator.next();
            return (OpenAiImageModelBuilder)factory.get();
        }
        return new OpenAiImageModelBuilder();
    }

    @Deprecated
    public static OpenAiImageModel withApiKey(String apiKey) {
        return OpenAiImageModel.builder().apiKey(apiKey).build();
    }

    private static Image fromImageData(ImageData data) {
        return Image.builder().url(data.url()).base64Data(data.b64Json()).revisedPrompt(data.revisedPrompt()).build();
    }

    private GenerateImagesRequest.Builder requestBuilder(String prompt) {
        GenerateImagesRequest.Builder requestBuilder = GenerateImagesRequest.builder().prompt(prompt).size(this.size).quality(this.quality).style(this.style).user(this.user).responseFormat(this.responseFormat);
        if ("dall-e-2".equals(this.modelName)) {
            requestBuilder.model(ImageModel.DALL_E_2);
        }
        return requestBuilder;
    }

    public static class OpenAiImageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private String size;
        private String quality;
        private String style;
        private String user;
        private String responseFormat;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Boolean withPersisting;
        private Path persistTo;
        private Map<String, String> customHeaders;

        public OpenAiImageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiImageModelBuilder modelName(OpenAiImageModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiImageModelBuilder withPersisting() {
            return this.withPersisting(true);
        }

        public OpenAiImageModelBuilder withPersisting(Boolean withPersisting) {
            this.withPersisting = withPersisting;
            return this;
        }

        public OpenAiImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiImageModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiImageModelBuilder size(String size) {
            this.size = size;
            return this;
        }

        public OpenAiImageModelBuilder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public OpenAiImageModelBuilder style(String style) {
            this.style = style;
            return this;
        }

        public OpenAiImageModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiImageModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OpenAiImageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiImageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiImageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiImageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiImageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiImageModelBuilder persistTo(Path persistTo) {
            this.persistTo = persistTo;
            return this;
        }

        public OpenAiImageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiImageModel build() {
            return new OpenAiImageModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.size, this.quality, this.style, this.user, this.responseFormat, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.withPersisting, this.persistTo, this.customHeaders);
        }

        public String toString() {
            return "OpenAiImageModel.OpenAiImageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", modelName=" + this.modelName + ", size=" + this.size + ", quality=" + this.quality + ", style=" + this.style + ", user=" + this.user + ", responseFormat=" + this.responseFormat + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", withPersisting=" + this.withPersisting + ", persistTo=" + this.persistTo + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

