/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.io.Writer;
import java.util.Objects;
import java.util.stream.IntStream;

final class TruncatingBufferedWriter
extends Writer
implements CharSequence {
    private final char[] buffer;
    private int position;
    private boolean truncated;

    TruncatingBufferedWriter(int capacity) {
        this.buffer = new char[capacity];
        this.position = 0;
        this.truncated = false;
    }

    char[] buffer() {
        return this.buffer;
    }

    int position() {
        return this.position;
    }

    void position(int index) {
        if (index < 0 || index >= this.buffer.length) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        this.position = index;
    }

    int capacity() {
        return this.buffer.length;
    }

    boolean truncated() {
        return this.truncated;
    }

    @Override
    public void write(int c) {
        if (this.position < this.buffer.length) {
            this.buffer[this.position++] = (char)c;
        } else {
            this.truncated = true;
        }
    }

    @Override
    public void write(char[] source) {
        Objects.requireNonNull(source, "source");
        this.write(source, 0, source.length);
    }

    @Override
    public void write(char[] source, int offset, int length) {
        Objects.requireNonNull(source, "source");
        if (offset < 0 || offset >= source.length) {
            throw new IndexOutOfBoundsException("invalid offset: " + offset);
        }
        if (length < 0 || Math.addExact(offset, length) > source.length) {
            throw new IndexOutOfBoundsException("invalid length: " + length);
        }
        int maxLength = this.buffer.length - this.position;
        if (length < maxLength) {
            System.arraycopy(source, offset, this.buffer, this.position, length);
            this.position += length;
        } else if (maxLength > 0) {
            System.arraycopy(source, offset, this.buffer, this.position, maxLength);
            this.position += maxLength;
            this.truncated = true;
        }
    }

    @Override
    public void write(String string) {
        Objects.requireNonNull(string, "string");
        int length = string.length();
        int maxLength = this.buffer.length - this.position;
        if (length < maxLength) {
            string.getChars(0, length, this.buffer, this.position);
            this.position += length;
        } else if (maxLength > 0) {
            string.getChars(0, maxLength, this.buffer, this.position);
            this.position += maxLength;
            this.truncated = true;
        }
    }

    @Override
    public void write(String string, int offset, int length) {
        Objects.requireNonNull(string, "string");
        if (offset < 0 || offset >= string.length()) {
            throw new IndexOutOfBoundsException("invalid offset: " + offset);
        }
        if (length < 0 || Math.addExact(offset, length) > string.length()) {
            throw new IndexOutOfBoundsException("invalid length: " + length);
        }
        int maxLength = this.buffer.length - this.position;
        if (length < maxLength) {
            string.getChars(offset, offset + length, this.buffer, this.position);
            this.position += length;
        } else if (maxLength > 0) {
            string.getChars(offset, offset + maxLength, this.buffer, this.position);
            this.position += maxLength;
            this.truncated = true;
        }
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence seq) {
        return seq == null ? this.append("null", 0, 4) : this.append(seq, 0, seq.length());
    }

    @Override
    public Writer append(CharSequence seq, int start, int end) {
        if (seq == null) {
            this.write("null");
            return this;
        }
        if (start < 0 || start >= seq.length()) {
            throw new IndexOutOfBoundsException("invalid start: " + start);
        }
        if (end < start || end > seq.length()) {
            throw new IndexOutOfBoundsException("invalid end: " + end);
        }
        int length = end - start;
        int maxLength = this.buffer.length - this.position;
        if (length < maxLength) {
            for (int i = start; i < end; ++i) {
                char c = seq.charAt(i);
                this.buffer[this.position++] = c;
            }
        } else if (maxLength > 0) {
            int truncatedEnd = start + maxLength;
            for (int i = start; i < truncatedEnd; ++i) {
                char c = seq.charAt(i);
                this.buffer[this.position++] = c;
            }
            this.truncated = true;
        }
        return this;
    }

    @Override
    public int length() {
        return this.position;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public String subSequence(int startIndex, int endIndex) {
        throw new UnsupportedOperationException("operation requires allocation, contradicting with the purpose of the class");
    }

    @Override
    public IntStream chars() {
        throw new UnsupportedOperationException("operation requires allocation, contradicting with the purpose of the class");
    }

    @Override
    public IntStream codePoints() {
        throw new UnsupportedOperationException("operation requires allocation, contradicting with the purpose of the class");
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.position = 0;
        this.truncated = false;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.position);
    }
}

