/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.Parameter;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.NonNullParameter;
import org.mariadb.jdbc.codec.ParameterWithCal;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.BulkExecutePacket;
import org.mariadb.jdbc.message.client.PreparePacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.array.FloatArray;
import org.mariadb.jdbc.plugin.codec.BigDecimalCodec;
import org.mariadb.jdbc.plugin.codec.BlobCodec;
import org.mariadb.jdbc.plugin.codec.BooleanCodec;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;
import org.mariadb.jdbc.plugin.codec.ByteCodec;
import org.mariadb.jdbc.plugin.codec.ClobCodec;
import org.mariadb.jdbc.plugin.codec.DateCodec;
import org.mariadb.jdbc.plugin.codec.DoubleCodec;
import org.mariadb.jdbc.plugin.codec.FloatArrayCodec;
import org.mariadb.jdbc.plugin.codec.FloatCodec;
import org.mariadb.jdbc.plugin.codec.FloatObjectArrayCodec;
import org.mariadb.jdbc.plugin.codec.IntCodec;
import org.mariadb.jdbc.plugin.codec.LongCodec;
import org.mariadb.jdbc.plugin.codec.ReaderCodec;
import org.mariadb.jdbc.plugin.codec.ShortCodec;
import org.mariadb.jdbc.plugin.codec.StreamCodec;
import org.mariadb.jdbc.plugin.codec.StringCodec;
import org.mariadb.jdbc.plugin.codec.TimeCodec;
import org.mariadb.jdbc.plugin.codec.TimestampCodec;
import org.mariadb.jdbc.util.ParameterList;

public abstract class BasePreparedStatement
extends Statement
implements PreparedStatement {
    protected final String sql;
    protected Parameters parameters;
    protected List<Parameters> batchParameters;
    protected Prepare prepareResult = null;

    public BasePreparedStatement(String sql, Connection con, ClosableLock lock, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(con, lock, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.sql = sql;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql:'" + this.sql + "'");
        sb.append(", parameters:[");
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter param = this.parameters.get(i);
            if (param == null) {
                sb.append("null");
            } else {
                sb.append(param.bestEffortStringValue(this.con.getContext()));
            }
            if (i == this.parameters.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getLastSql() {
        return this.sql;
    }

    public void setPrepareResult(Prepare prepareResult) {
        this.prepareResult = prepareResult;
    }

    public ColumnDecoder[] getMeta() {
        return this.prepareResult.getColumns();
    }

    public void updateMeta(ColumnDecoder[] ci) {
        this.prepareResult.setColumns(ci);
    }

    @Override
    public abstract boolean execute() throws SQLException;

    @Override
    public abstract ResultSet executeQuery() throws SQLException;

    @Override
    public abstract int executeUpdate() throws SQLException;

    @Override
    public abstract long executeLargeUpdate() throws SQLException;

    @Override
    public abstract void addBatch() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    public void setParameter(int index, Parameter param) {
        this.parameters.set(index, param);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.exceptionFactory().create("addBatch(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("execute(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeQuery(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.exceptionFactory().create("executeLargeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement");
    }

    private void checkIndex(int index) throws SQLException {
        if (index <= 0) {
            throw this.exceptionFactory().create(String.format("wrong parameter index %s", index));
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Boolean>(BooleanCodec.INSTANCE, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Byte>(ByteCodec.INSTANCE, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Short>(ShortCodec.INSTANCE, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Integer>(IntCodec.INSTANCE, x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Long>(LongCodec.INSTANCE, x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Float>(FloatCodec.INSTANCE, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new NonNullParameter<Double>(DoubleCodec.INSTANCE, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<BigDecimal>(BigDecimalCodec.INSTANCE, x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<byte[]>(ByteArrayCodec.INSTANCE, x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Date>(DateCodec.INSTANCE, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Time>(TimeCodec.INSTANCE, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Timestamp>(TimestampCodec.INSTANCE, x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, Long.valueOf(length)));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.parameters = new ParameterList();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchParameters = new ArrayList<Parameters>();
        super.clearBatch();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setInternalObject(parameterIndex, x, null, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, Long.valueOf(length)));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.exceptionFactory().notSupported("REF parameter are not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Blob>(BlobCodec.INSTANCE, x));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Clob>(ClobCodec.INSTANCE, x));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkIndex(parameterIndex);
        if (x == null) {
            this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
            return;
        }
        if (x instanceof FloatArray) {
            this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<float[]>(FloatArrayCodec.INSTANCE, (float[])x.getArray()));
            return;
        }
        throw this.exceptionFactory().notSupported(String.format("this type of Array parameter %s is not supported", x.getClass()));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Date>(DateCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Time>(TimeCodec.INSTANCE, x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCal<Timestamp>(TimestampCodec.INSTANCE, x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, x == null ? null : x.toString()));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId parameter are not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<String>(StringCodec.INSTANCE, value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, value, length));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<NClob>(ClobCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, inputStream, length));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML parameter are not supported");
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, Long.valueOf(scaleOrLength));
    }

    private void setInternalObject(int parameterIndex, Object obj, Integer targetSqlType, Long scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        if (obj == null) {
            this.parameters.set(parameterIndex - 1, org.mariadb.jdbc.codec.Parameter.NULL_PARAMETER);
            return;
        }
        if (targetSqlType != null) {
            if (this.trySetArrayType(parameterIndex, obj, targetSqlType)) {
                return;
            }
            this.checkUnsupportedTypes(targetSqlType);
            if (this.trySetStringOrCharacter(parameterIndex, obj, targetSqlType)) {
                return;
            }
            if (this.trySetNumber(parameterIndex, obj, targetSqlType)) {
                return;
            }
            if (this.trySetByteArray(parameterIndex, obj, targetSqlType, scaleOrLength)) {
                return;
            }
        }
        this.trySetWithCodec(parameterIndex, obj, scaleOrLength);
    }

    private boolean trySetArrayType(int parameterIndex, Object obj, Integer targetSqlType) throws SQLException {
        if (targetSqlType != 2003) {
            return false;
        }
        if (obj instanceof float[]) {
            this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<float[]>(FloatArrayCodec.INSTANCE, (float[])obj));
            return true;
        }
        if (obj instanceof Float[]) {
            this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Float[]>(FloatObjectArrayCodec.INSTANCE, (Float[])obj));
            return true;
        }
        if (obj instanceof FloatArray) {
            this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<float[]>(FloatArrayCodec.INSTANCE, (float[])((FloatArray)obj).getArray()));
            return true;
        }
        throw this.exceptionFactory().notSupported(String.format("ARRAY Type not supported for %s", obj.getClass().getName()));
    }

    private void checkUnsupportedTypes(Integer targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2006: 
            case 2009: {
                throw this.exceptionFactory().notSupported("Type not supported");
            }
        }
    }

    private boolean trySetStringOrCharacter(int parameterIndex, Object obj, Integer targetSqlType) throws SQLException {
        if (!(obj instanceof String) && !(obj instanceof Character)) {
            return false;
        }
        if (targetSqlType == 2004) {
            throw this.exceptionFactory().create(String.format("Cannot convert a %s to a Blob", obj instanceof String ? "string" : "character"));
        }
        String str = obj instanceof String ? (String)obj : ((Character)obj).toString();
        return this.handleStringConversion(parameterIndex, str, targetSqlType);
    }

    private boolean handleStringConversion(int parameterIndex, String str, Integer targetSqlType) throws SQLException {
        try {
            switch (targetSqlType) {
                case -7: 
                case 16: {
                    this.setBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                    return true;
                }
                case -6: {
                    this.setByte(parameterIndex, Byte.parseByte(str));
                    return true;
                }
                case 5: {
                    this.setShort(parameterIndex, Short.parseShort(str));
                    return true;
                }
                case 4: {
                    this.setInt(parameterIndex, Integer.parseInt(str));
                    return true;
                }
                case 6: 
                case 8: {
                    this.setDouble(parameterIndex, Double.parseDouble(str));
                    return true;
                }
                case 7: {
                    this.setFloat(parameterIndex, Float.parseFloat(str));
                    return true;
                }
                case -5: {
                    this.setLong(parameterIndex, Long.parseLong(str));
                    return true;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(parameterIndex, new BigDecimal(str));
                    return true;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    this.setString(parameterIndex, str);
                    return true;
                }
                case 93: {
                    this.handleTimestampString(parameterIndex, str);
                    return true;
                }
                case 92: {
                    this.setTime(parameterIndex, Time.valueOf(str));
                    return true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw this.exceptionFactory().create(String.format("Could not convert [%s] to java.sql.Type %s", str, targetSqlType), "HY000", e);
        }
        throw this.exceptionFactory().create(String.format("Could not convert [%s] to %s", str, targetSqlType));
    }

    private void handleTimestampString(int parameterIndex, String str) throws SQLException {
        if (str.startsWith("0000-00-00")) {
            this.setTimestamp(parameterIndex, null);
        } else {
            this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
        }
    }

    private boolean trySetNumber(int parameterIndex, Object obj, Integer targetSqlType) throws SQLException {
        if (!(obj instanceof Number)) {
            return false;
        }
        Number bd = (Number)obj;
        switch (targetSqlType) {
            case -6: {
                this.setByte(parameterIndex, bd.byteValue());
                return true;
            }
            case 5: {
                this.setShort(parameterIndex, bd.shortValue());
                return true;
            }
            case 4: {
                this.setInt(parameterIndex, bd.intValue());
                return true;
            }
            case -5: {
                this.setLong(parameterIndex, bd.longValue());
                return true;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, bd.doubleValue());
                return true;
            }
            case 7: {
                this.setFloat(parameterIndex, bd.floatValue());
                return true;
            }
            case 2: 
            case 3: {
                this.handleNumericType(parameterIndex, obj, bd);
                return true;
            }
            case -7: {
                this.setBoolean(parameterIndex, bd.shortValue() != 0);
                return true;
            }
            case 1: 
            case 12: {
                this.setString(parameterIndex, bd.toString());
                return true;
            }
        }
        throw this.exceptionFactory().create(String.format("Could not convert [%s] to %s", bd, targetSqlType));
    }

    private void handleNumericType(int parameterIndex, Object obj, Number bd) throws SQLException {
        if (obj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
        } else if (obj instanceof Double || obj instanceof Float) {
            this.setDouble(parameterIndex, bd.doubleValue());
        } else {
            this.setLong(parameterIndex, bd.longValue());
        }
    }

    private boolean trySetByteArray(int parameterIndex, Object obj, Integer targetSqlType, Long scaleOrLength) throws SQLException {
        if (!(obj instanceof byte[])) {
            return false;
        }
        byte[] bytes = (byte[])obj;
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: {
                if (scaleOrLength != null) {
                    this.setBytes(parameterIndex, Arrays.copyOfRange(bytes, 0, scaleOrLength.intValue()));
                } else {
                    this.setBytes(parameterIndex, bytes);
                }
                return true;
            }
            case 2004: {
                if (scaleOrLength != null) {
                    this.setBlob(parameterIndex, new MariaDbBlob(bytes, 0, scaleOrLength.intValue()));
                } else {
                    this.setBlob(parameterIndex, new MariaDbBlob(bytes));
                }
                return true;
            }
        }
        throw this.exceptionFactory().create("Can only convert a byte[] to BINARY, VARBINARY, LONGVARBINARY or BLOB type");
    }

    private void trySetWithCodec(int parameterIndex, Object obj, Long scaleOrLength) throws SQLException {
        for (Codec<?> codec : this.con.getContext().getConf().codecs()) {
            if (!codec.canEncode(obj)) continue;
            org.mariadb.jdbc.codec.Parameter<Object> p = new org.mariadb.jdbc.codec.Parameter<Object>(codec, obj, scaleOrLength);
            this.parameters.set(parameterIndex - 1, p);
            return;
        }
        throw new SQLException(String.format("Type %s not supported type", obj.getClass().getName()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader, length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<InputStream>(StreamCodec.INSTANCE, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new org.mariadb.jdbc.codec.Parameter<Reader>(ReaderCodec.INSTANCE, reader));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType == null ? null : targetSqlType.getVendorTypeNumber(), Long.valueOf(scaleOrLength));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType == null ? null : targetSqlType.getVendorTypeNumber(), null);
    }

    protected abstract BatchTypeState executeInternalPreparedBatch() throws SQLException;

    /*
     * Exception decompiling
     */
    @Override
    public int[] executeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isBatchEmpty() {
        return this.batchParameters == null || this.batchParameters.isEmpty();
    }

    private int[] executeBatchInternal() throws SQLException {
        int[] bulkInsertUpdates;
        BatchTypeState batchTypeState = this.executeInternalPreparedBatch();
        int[] updates = new int[this.batchParameters.size()];
        if (this.shouldHandleBulkUnitResults(batchTypeState == BatchTypeState.Bulk)) {
            return this.handleBulkUnitResults(updates);
        }
        if (this.shouldHandleBulkInsert(batchTypeState == BatchTypeState.Bulk || batchTypeState == BatchTypeState.Rewrite) && (bulkInsertUpdates = this.handleBulkInsert(updates)) != null) {
            return bulkInsertUpdates;
        }
        return this.handleStandardResults(updates);
    }

    private boolean shouldHandleBulkUnitResults(boolean wasBulk) {
        return wasBulk && this.con.getContext().hasClientCapability(0x2000000000L);
    }

    private int[] handleBulkUnitResults(int[] updates) throws SQLException {
        int updateIdx = 0;
        Arrays.fill(updates, -2);
        for (Completion completion : this.results) {
            CompleteResult completeResult;
            if (!(completion instanceof CompleteResult) || !(completeResult = (CompleteResult)completion).isBulkResult()) continue;
            updateIdx = this.processBulkResult(updates, updateIdx, completeResult);
        }
        this.currResult = (Completion)this.results.remove(0);
        return updates;
    }

    private long[] handleLongBulkUnitResults(long[] updates) throws SQLException {
        int updateIdx = 0;
        Arrays.fill(updates, -2L);
        for (Completion completion : this.results) {
            CompleteResult completeResult;
            if (!(completion instanceof CompleteResult) || !(completeResult = (CompleteResult)completion).isBulkResult()) continue;
            updateIdx = this.processLongBulkResult(updates, updateIdx, completeResult);
        }
        this.currResult = (Completion)this.results.remove(0);
        return updates;
    }

    private int processBulkResult(int[] updates, int updateIdx, Result unitaryResults) throws SQLException {
        if (!unitaryResults.isBulkResult()) {
            return updateIdx;
        }
        unitaryResults.beforeFirst();
        while (unitaryResults.next()) {
            updates[updateIdx++] = unitaryResults.getInt(2);
        }
        return updateIdx;
    }

    private int processLongBulkResult(long[] updates, int updateIdx, Result unitaryResults) throws SQLException {
        if (!unitaryResults.isBulkResult()) {
            return updateIdx;
        }
        unitaryResults.beforeFirst();
        while (unitaryResults.next()) {
            updates[updateIdx++] = unitaryResults.getInt(2);
        }
        return updateIdx;
    }

    private boolean shouldHandleBulkInsert(boolean wasBulk) {
        return wasBulk && this.clientParser.isInsert() && !this.clientParser.isInsertDuplicate();
    }

    private int[] handleBulkInsert(int[] updates) {
        int totalAffectedRows = this.calculateTotalAffectedRows();
        if (totalAffectedRows == updates.length) {
            Arrays.fill(updates, 1);
            this.currResult = (Completion)this.results.remove(0);
            return updates;
        }
        return null;
    }

    private long[] handleLongBulkInsert(long[] updates) {
        int totalAffectedRows = this.calculateTotalAffectedRows();
        if (totalAffectedRows == updates.length) {
            Arrays.fill(updates, 1L);
            this.currResult = (Completion)this.results.remove(0);
            return updates;
        }
        return null;
    }

    private int calculateTotalAffectedRows() {
        return this.results.stream().mapToInt(result -> (int)((OkPacket)result).getAffectedRows()).sum();
    }

    private int[] handleStandardResults(int[] updates) {
        if (this.results.size() != updates.length) {
            Arrays.fill(updates, -2);
        } else {
            this.processIndividualResults(updates);
        }
        this.currResult = (Completion)this.results.remove(0);
        return updates;
    }

    private long[] handleStandardLongResults(long[] updates) {
        if (this.results.size() != updates.length) {
            Arrays.fill(updates, -2L);
        } else {
            this.processIndividualLongResults(updates);
        }
        this.currResult = (Completion)this.results.remove(0);
        return updates;
    }

    private void processIndividualResults(int[] updates) {
        for (int i = 0; i < updates.length; ++i) {
            updates[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
        }
    }

    private void processIndividualLongResults(long[] updates) {
        for (int i = 0; i < updates.length; ++i) {
            updates[i] = this.results.get(i) instanceof OkPacket ? (long)((int)((OkPacket)this.results.get(i)).getAffectedRows()) : -2L;
        }
    }

    private void handleExecutionError(SQLException e) {
        this.results = null;
        this.currResult = null;
    }

    private void cleanupResources() {
        this.localInfileInputStream = null;
        this.batchParameters.clear();
    }

    private long[] executeLongBatchInternal() throws SQLException {
        long[] bulkInsertUpdates;
        BatchTypeState batchTypeState = this.executeInternalPreparedBatch();
        long[] updates = new long[this.batchParameters.size()];
        if (this.shouldHandleBulkUnitResults(batchTypeState == BatchTypeState.Bulk)) {
            return this.handleLongBulkUnitResults(updates);
        }
        if (this.shouldHandleBulkInsert(batchTypeState == BatchTypeState.Bulk || batchTypeState == BatchTypeState.Rewrite) && (bulkInsertUpdates = this.handleLongBulkInsert(updates)) != null) {
            return bulkInsertUpdates;
        }
        return this.handleStandardLongResults(updates);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void executeBatchBulk(String cmd) throws SQLException {
        if (this.prepareResult == null && this.con.cachePrepStmts()) {
            this.prepareResult = this.con.getContext().getPrepareCacheCmd(cmd, this);
        }
        try {
            if (this.prepareResult == null) {
                ClientMessage[] packets = new ClientMessage[]{new PreparePacket(cmd), new BulkExecutePacket(null, this.batchParameters, cmd, this)};
                List<Completion> res = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
                this.results = res.get(0) instanceof PrepareResultPacket ? res.subList(1, res.size()) : res;
            } else {
                this.results = this.con.getClient().execute(new BulkExecutePacket(this.prepareResult, this.batchParameters, cmd, this), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
            }
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(Collections.emptyList(), this.batchParameters.size(), bue);
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.prepareResult = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkNotClosed();
        this.validateGeneratedKeysSupport();
        List<String[]> insertIds = this.extractInsertIds();
        if (!insertIds.isEmpty()) {
            return this.createGeneratedKeysResultSet(insertIds);
        }
        return super.getGeneratedKeys();
    }

    private void validateGeneratedKeysSupport() throws SQLException {
        if (this.autoGeneratedKeys != 1) {
            throw new SQLException("Cannot return generated keys: query was not set with Statement.RETURN_GENERATED_KEYS");
        }
    }

    private List<String[]> extractInsertIds() throws SQLException {
        if (this.currResult == null) {
            return Collections.emptyList();
        }
        ArrayList<String[]> insertIds = new ArrayList<String[]>(this.results.size() + 1);
        List<Completion> allResults = this.getAllResults();
        for (Completion completion : allResults) {
            if (!this.isValidBulkResult(completion)) continue;
            this.processUnitaryResults((CompleteResult)completion, insertIds);
        }
        return insertIds;
    }

    private List<Completion> getAllResults() {
        ArrayList<Completion> allResults = new ArrayList<Completion>(this.results);
        allResults.add(this.currResult);
        return allResults;
    }

    private boolean isValidBulkResult(Completion completion) {
        return completion instanceof CompleteResult && ((CompleteResult)completion).isBulkResult();
    }

    private void processUnitaryResults(CompleteResult unitaryResults, List<String[]> insertIds) throws SQLException {
        unitaryResults.beforeFirst();
        while (unitaryResults.next()) {
            this.addAutoGeneratedIdIfPresent(unitaryResults, insertIds);
        }
    }

    private void addAutoGeneratedIdIfPresent(Result unitaryResults, List<String[]> insertIds) throws SQLException {
        int autoGeneratedId = unitaryResults.getInt(1);
        if (autoGeneratedId != 0) {
            insertIds.add(new String[]{String.valueOf(autoGeneratedId)});
        }
    }

    private ResultSet createGeneratedKeysResultSet(List<String[]> insertIds) {
        String[][] ids = (String[][])insertIds.toArray((T[])new String[0][]);
        return CompleteResult.createResultSet("insert_id", DataType.BIGINT, ids, this.con.getContext(), 544, this.resultSetType);
    }

    protected static enum BatchTypeState {
        Normal,
        Bulk,
        Rewrite;

    }
}

