/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.DataManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.MetadataLoader;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.manager.MetadataLoaderImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSource;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;

public class DataManagerImpl
implements DataManager {
    private Connection c = null;
    private String schema = null;

    public DataManagerImpl(Connection connection, String string) {
        this.c = connection;
        this.schema = string;
    }

    @Override
    public void delete(int n2) throws MetadataException {
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        int n3 = metadataSourceWriter.removeEntry(this.c, n2);
        if (n3 == 0) {
            throw new MetadataException(null, null);
        }
    }

    @Override
    public InputStream getContent(int n2) throws MetadataException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetadataSourceReader metadataSourceReader = MetadataSourceReader.getInstance(this.schema);
        ZipInputStream zipInputStream = null;
        try {
            metadataSourceReader.getContentFor(this.c, n2, byteArrayOutputStream);
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            zipInputStream = new ZipInputStream(byteArrayInputStream);
            zipInputStream.getNextEntry();
        }
        catch (SQLException sQLException) {
            throw new MetadataException(null, sQLException);
        }
        catch (IOException iOException) {
            throw new MetadataException(null, iOException);
        }
        return zipInputStream;
    }

    @Override
    public MetadataLoader getLoader() throws MetadataException {
        return new MetadataLoaderImpl(this.c, this.schema, null, null, null);
    }

    @Override
    public MetadataLoader getLoader(String string) throws MetadataException {
        return new MetadataLoaderImpl(this.c, this.schema, string, null, null);
    }

    @Override
    public MetadataLoader getLoader(String string, String string2) throws MetadataException {
        return new MetadataLoaderImpl(this.c, this.schema, null, string, string2);
    }

    @Override
    public List<SavedDataInfo> list() throws MetadataException {
        return this.list(false);
    }

    @Override
    public List<SavedDataInfo> listNonGrouped() throws MetadataException {
        return this.list(true);
    }

    private List<SavedDataInfo> list(boolean bl2) throws MetadataException {
        MetadataSourceReader metadataSourceReader = MetadataSourceReader.getInstance(this.schema);
        ArrayList<SavedDataInfo> arrayList = new ArrayList<SavedDataInfo>();
        try {
            List<MetadataSource> list = metadataSourceReader.getValues(this.c, bl2);
            for (MetadataSource metadataSource : list) {
                arrayList.add(metadataSource);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new MetadataException(null, sQLException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new MetadataException(null, iOException);
        }
        return arrayList;
    }
}

