/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import us.fatehi.utility.Utility;

public final class TableType
implements Serializable,
Comparable<TableType> {
    private static final long serialVersionUID = -8172248482959041873L;
    public static final TableType UNKNOWN = new TableType("unknown");
    private final String tableType;

    public TableType(String tableTypeString) {
        Utility.requireNotBlank((String)tableTypeString, (String)"No table type provided");
        this.tableType = tableTypeString.trim();
    }

    @Override
    public int compareTo(TableType other) {
        String otherToString;
        if (other == null) {
            return -1;
        }
        String thisToString = this.toString();
        if (thisToString.equalsIgnoreCase(otherToString = other.toString())) {
            return 0;
        }
        boolean isThisTable = "TABLE".equalsIgnoreCase(thisToString);
        boolean isOtherTable = "TABLE".equalsIgnoreCase(otherToString);
        if (isThisTable && !isOtherTable) {
            return -1;
        }
        if (!isThisTable && isOtherTable) {
            return 1;
        }
        boolean isThisView = "VIEW".equalsIgnoreCase(thisToString);
        boolean isOtherView = "VIEW".equalsIgnoreCase(otherToString);
        if (isThisView && !isOtherView) {
            return -1;
        }
        if (!isThisView && isOtherView) {
            return 1;
        }
        return thisToString.compareTo(otherToString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TableType)) {
            return false;
        }
        TableType other = (TableType)obj;
        if (this.tableType == null) {
            return other.tableType == null;
        }
        return this.tableType.equalsIgnoreCase(other.tableType);
    }

    public String getTableType() {
        return this.tableType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.tableType == null ? 0 : this.tableType.toLowerCase().hashCode());
    }

    public boolean isEqualTo(String testTableType) {
        if (Utility.isBlank((String)testTableType)) {
            return false;
        }
        return this.tableType.equalsIgnoreCase(testTableType.trim());
    }

    public boolean isView() {
        return this.tableType != null && (this.tableType.toUpperCase().contains("VIEW") || this.tableType.toUpperCase().contains("MATERIALIZED"));
    }

    public String toString() {
        return this.tableType.toLowerCase();
    }
}

