# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: BSD-2-Clause

"""
Implementation of some CFFI functions
"""

from numba.cuda.core.imputils import Registry
from numba.cuda import types

registry = Registry("cffiimpl")


@registry.lower("ffi.from_buffer", types.Buffer)
def from_buffer(context, builder, sig, args):
    assert len(sig.args) == 1
    assert len(args) == 1
    [fromty] = sig.args
    [val] = args
    # Type inference should have prevented passing a buffer from an
    # array to a pointer of the wrong type
    assert fromty.dtype == sig.return_type.dtype
    ary = context.make_array(fromty)(context, builder, val)
    return ary.data
