/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartStackMode
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartStackMode() {
        super(false, CommandChartStackMode.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartStackMode.class.getName(), RegexLeaf.start(), new RegexLeaf("stackMode"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "MODE", "(grouped|stacked)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        ChartDiagram.StackMode stackMode;
        String mode = arg.get("MODE", 0);
        switch (mode.toLowerCase()) {
            case "grouped": {
                stackMode = ChartDiagram.StackMode.GROUPED;
                break;
            }
            case "stacked": {
                stackMode = ChartDiagram.StackMode.STACKED;
                break;
            }
            default: {
                return CommandExecutionResult.error("Invalid stack mode: " + mode);
            }
        }
        return diagram.setStackMode(stackMode);
    }
}

