-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Armenian names

-- References
-- Wikipedia: Armenian name - https://en.wikipedia.org/wiki/Armenian_name
-- https://github.com/Ninble/name-census-top-100 (GPL-3.0)

local CultureName = require './common'

local male = {
    "Albert",
    "Alejandro",
    "Aleksej",
    "Aleksandr",
    "Alen",
    "Alexander",
    "Ali",
    "Andrej",
    "Andranik",
    "Andres",
    "Ara",
    "Aram",
    "Ararat",
    "Areg",
    "Arman",
    "Armen",
    "Armin",
    "Arlashes",
    "Arsen",
    "Arshak",
    "Artak",
    "Artem",
    "Arthur",
    "Artur",
    "Artyom",
    "Ashot",
    "Bagrat",
    "Camilo",
    "Carlos",
    "Daniel",
    "David",
    "Davit",
    "Denis",
    "Diego",
    "Dmitrij",
    "Edgar",
    "Eduard",
    "Erik",
    "Felipe",
    "Gagik",
    "Garik",
    "Gevorg",
    "Gor",
    "Grigor",
    "Hakob",
    "Hamlet",
    "Harout",
    "Harut",
    "Harutyun",
    "Hayk",
    "Hector",
    "Hovhannes",
    "Hovsep",
    "Hrant",
    "Hrayr",
    "Ivan",
    "Jhon",
    "Jorge",
    "Juan",
    "Julian",
    "Levon",
    "Mauricio",
    "Mher",
    "Michael",
    "Mihran",
    "Mikayel",
    "Mohammad",
    "Mohammed",
    "Narek",
    "Nikita",
    "Norayr",
    "Pavel",
    "Rafael",
    "Rafayel",
    "Richard",
    "Robert",
    "Roman",
    "Ruben",
    "Samvel",
    "Santiago",
    "Sargis",
    "Saro",
    "Sebastian",
    "Sergej",
    "Sergey",
    "Sergio",
    "Sevak",
    "Stepan",
    "Suren",
    "Taron",
    "Tigran",
    "Vahagn",
    "Vahan",
    "Vahe",
    "Vahram",
    "Vardan",
    "Vazgen",
    "Vigen",
    "Vladimir",
}

local female = {
    "Adriana",
    "Alejandra",
    "Alla",
    "Alina",
    "Anahit",
    "Anastasija",
    "Angie",
    "Angela",
    "Ani",
    "Ann",
    "Anna",
    "Annie",
    "Anush",
    "Arevik",
    "Armenia",
    "Armine",
    "Arpi",
    "Arpine",
    "Asya",
    "Astghik",
    "Christina",
    "Diana",
    "Ekaterina",
    "Elen",
    "Elena",
    "Elina",
    "Emma",
    "Eva",
    "Fernanda",
    "Gayane",
    "Gohar",
    "Hasmik",
    "Haykuhi",
    "Heghine",
    "Hermine",
    "Hripsime",
    "Inessa",
    "Inga",
    "Inna",
    "Irina",
    "Karen",
    "Karina",
    "Karine",
    "Kristina",
    "Larisa",
    "Laura",
    "Lena",
    "Liana",
    "Lilit",
    "Lilith",
    "Lucy",
    "Lusine",
    "Mane",
    "Margarita",
    "Mari",
    "Maria",
    "Mariam",
    "Marianna",
    "Marija",
    "Marina",
    "Marine",
    "Mary",
    "Meline",
    "Meri",
    "Milena",
    "Naira",
    "Nairi",
    "Nana",
    "Nane",
    "Nare",
    "Narine",
    "Natalia",
    "Nazeli",
    "Nelly",
    "Nune",
    "Olga",
    "Ruzanna",
    "Sara",
    "Sasha",
    "Satenik",
    "Seda",
    "Shushan",
    "Shushanik",
    "Siranush",
    "Sona",
    "Susanna",
    "Svetlana",
    "Syuzanna",
    "Tamara",
    "Tatev",
    "Tatevik",
    "Tatiana",
    "Tatjana",
    "Tiko",
    "Ulija",
    "Ulja",
    "Valentina",
    "Varduhi",
    "Veronika",
    "Zara",
}

local surname = {
    "Aalamanyan",
    "Abgaryan",
    "Abrahamyan",
    "Adamyan",
    "Aghababyan",
    "Aghajanyan",
    "Aghayan",
    "Aghazaryan",
    "Aharonyan",
    "Aivazian",
    "Akopyan",
    "Alaverdyan",
    "Aleksanyan",
    "Amarian",
    "Amatuni",
    "Andonian",
    "Antanyan",
    "Aprahamian",
    "Arabyan",
    "Araratyan",
    "Arshakyan",
    "Asatryan",
    "Aslanyan",
    "Atabekyan",
    "Avagyan",
    "Avakyan",
    "Avdalyan",
    "Avedikyan",
    "Avedisyan",
    "Avetisyan",
    "Ayvazyan",
    "Azaryan",
    "Babayan",
    "Badalyan",
    "Baghdasaryan",
    "Baghdikyan",
    "Baghdoyan",
    "Baghramyan",
    "Bardakjian",
    "Barseghyan",
    "Barsoumian",
    "Bedirian",
    "Bekaryan",
    "Berberyan",
    "Bleyan",
    "Bobokhyan",
    "Boyajian",
    "Chilingaryan",
    "Dadyan",
    "Darpinyan",
    "Darvishyan",
    "Davidyan",
    "Demirchyan",
    "Derderian",
    "Dzhanyan",
    "Edilyan",
    "Eghiazaryan",
    "Eghoyan",
    "Elbakyan",
    "Erznkyan",
    "Gagikyan",
    "Galstyan",
    "Garabedian",
    "Garanian",
    "Gevorgyan",
    "Ghazaryan",
    "Ghazikyan",
    "Ghukasyan",
    "Ginosyan",
    "Grigoryan",
    "Hacobian",
    "Hakobyan",
    "Hambardzumyan",
    "Haroutunian",
    "Hovannisian",
    "Hovhannisyan",
    "Hovsepyan",
    "Hovsepian",
    "Karapetyan",
    "Khachatryan",
    "Kirakosyan",
    "Kocharyan",
    "Lopez",
    "Manukyan",
    "Margaryan",
    "Martirosyan",
    "Melikyan",
    "Mikayelyan",
    "Minasyan",
    "Mirzoyan",
    "Mkrtchyan",
    "Movsisyan",
    "Muradyan",
    "Nahapetyan",
    "Nazaretyan",
    "Nersisyan",
    "Nikoghosyan",
    "Orozco",
    "Papikyan",
    "Petrosyan",
    "Poghosyan",
    "Ramirez",
    "Rodriguez",
    "Safaryan",
    "Sargsyan",
    "Simonyan",
    "Stepanyan",
    "Tadevosyan",
    "Tonoyan",
    "Torosyan",
    "Tovmasyan",
    "Travelian",
    "Vardanyan",
    "Yeganyan",
    "Yesayan",
    "Zakharyan",
}

local Armenian = CultureName.New({
    male = male,
    female = female,
    surname = surname,
    name = "Armenian",
    code = "hy", -- ISO 639-1 code for Armenian
})

return Armenian
