/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression;

import com.oracle.labs.mlrg.olcut.util.MutableDouble;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.MutableNumber;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputInfo;
import org.tribuo.regression.ImmutableRegressionInfo;
import org.tribuo.regression.MutableRegressionInfo;
import org.tribuo.regression.Regressor;

public abstract class RegressionInfo
implements OutputInfo<Regressor> {
    private static final long serialVersionUID = 2L;
    private static final MutableDouble NAN = new MutableDouble(Double.NaN);
    protected Map<String, MutableDouble> maxMap = new LinkedHashMap<String, MutableDouble>();
    protected Map<String, MutableDouble> minMap = new LinkedHashMap<String, MutableDouble>();
    protected Map<String, MutableDouble> meanMap = new LinkedHashMap<String, MutableDouble>();
    protected Map<String, MutableDouble> sumSquaresMap = new LinkedHashMap<String, MutableDouble>();
    protected Map<String, MutableLong> countMap = new TreeMap<String, MutableLong>();
    protected long overallCount = 0L;
    protected int unknownCount = 0;

    RegressionInfo() {
    }

    RegressionInfo(RegressionInfo other) {
        this.maxMap = MutableNumber.copyMap(other.maxMap);
        this.minMap = MutableNumber.copyMap(other.minMap);
        this.meanMap = MutableNumber.copyMap(other.meanMap);
        this.sumSquaresMap = MutableNumber.copyMap(other.sumSquaresMap);
        this.countMap = MutableNumber.copyMap(other.countMap);
        this.overallCount = other.overallCount;
    }

    public int getUnknownCount() {
        return this.unknownCount;
    }

    public Set<Regressor> getDomain() {
        TreeSet<Regressor.DimensionTuple> outputs = new TreeSet<Regressor.DimensionTuple>(Comparator.comparing(Regressor.DimensionTuple::getName));
        for (Map.Entry<String, MutableDouble> e : this.minMap.entrySet()) {
            outputs.add(new Regressor.DimensionTuple(e.getKey(), e.getValue().doubleValue()));
        }
        SortedSet<Regressor> setOutputs = Collections.unmodifiableSortedSet(outputs);
        return setOutputs;
    }

    public double getMin(String name) {
        return this.minMap.getOrDefault(name, NAN).doubleValue();
    }

    public double getMax(String name) {
        return this.maxMap.getOrDefault(name, NAN).doubleValue();
    }

    public double getMean(String name) {
        return this.meanMap.getOrDefault(name, NAN).doubleValue();
    }

    public double getVariance(String name) {
        MutableDouble sumSquaresDbl = this.sumSquaresMap.get(name);
        if (sumSquaresDbl != null) {
            return sumSquaresDbl.doubleValue() / (double)(this.countMap.get(name).longValue() - 1L);
        }
        return Double.NaN;
    }

    public int size() {
        return this.countMap.size();
    }

    public ImmutableOutputInfo<Regressor> generateImmutableOutputInfo() {
        return new ImmutableRegressionInfo(this);
    }

    public MutableOutputInfo<Regressor> generateMutableOutputInfo() {
        return new MutableRegressionInfo(this);
    }

    public abstract RegressionInfo copy();

    public Iterable<Pair<String, Long>> outputCountsIterable() {
        ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>();
        for (Map.Entry<String, MutableLong> e : this.countMap.entrySet()) {
            list.add((Pair<String, Long>)new Pair((Object)e.getKey(), (Object)e.getValue().longValue()));
        }
        return list;
    }
}

