/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddressFamily;
import software.amazon.awssdk.services.ec2.model.IpamPoolAwsService;
import software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource;
import software.amazon.awssdk.services.ec2.model.IpamPoolSourceResource;
import software.amazon.awssdk.services.ec2.model.IpamPoolState;
import software.amazon.awssdk.services.ec2.model.IpamResourceTag;
import software.amazon.awssdk.services.ec2.model.IpamResourceTagListCopier;
import software.amazon.awssdk.services.ec2.model.IpamScopeType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPool> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamPool.getter(IpamPool::ownerId)).setter(IpamPool.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(IpamPool.getter(IpamPool::ipamPoolId)).setter(IpamPool.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("ipamPoolId").build()}).build();
    private static final SdkField<String> SOURCE_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIpamPoolId").getter(IpamPool.getter(IpamPool::sourceIpamPoolId)).setter(IpamPool.setter(Builder::sourceIpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpamPoolId").unmarshallLocationName("sourceIpamPoolId").build()}).build();
    private static final SdkField<String> IPAM_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolArn").getter(IpamPool.getter(IpamPool::ipamPoolArn)).setter(IpamPool.setter(Builder::ipamPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolArn").unmarshallLocationName("ipamPoolArn").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeArn").getter(IpamPool.getter(IpamPool::ipamScopeArn)).setter(IpamPool.setter(Builder::ipamScopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeArn").unmarshallLocationName("ipamScopeArn").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeType").getter(IpamPool.getter(IpamPool::ipamScopeTypeAsString)).setter(IpamPool.setter(Builder::ipamScopeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeType").unmarshallLocationName("ipamScopeType").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(IpamPool.getter(IpamPool::ipamArn)).setter(IpamPool.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(IpamPool.getter(IpamPool::ipamRegion)).setter(IpamPool.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(IpamPool.getter(IpamPool::locale)).setter(IpamPool.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").unmarshallLocationName("locale").build()}).build();
    private static final SdkField<Integer> POOL_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PoolDepth").getter(IpamPool.getter(IpamPool::poolDepth)).setter(IpamPool.setter(Builder::poolDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolDepth").unmarshallLocationName("poolDepth").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamPool.getter(IpamPool::stateAsString)).setter(IpamPool.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(IpamPool.getter(IpamPool::stateMessage)).setter(IpamPool.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpamPool.getter(IpamPool::description)).setter(IpamPool.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> AUTO_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoImport").getter(IpamPool.getter(IpamPool::autoImport)).setter(IpamPool.setter(Builder::autoImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImport").unmarshallLocationName("autoImport").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ADVERTISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAdvertisable").getter(IpamPool.getter(IpamPool::publiclyAdvertisable)).setter(IpamPool.setter(Builder::publiclyAdvertisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAdvertisable").unmarshallLocationName("publiclyAdvertisable").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(IpamPool.getter(IpamPool::addressFamilyAsString)).setter(IpamPool.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("addressFamily").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MIN_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMinNetmaskLength").getter(IpamPool.getter(IpamPool::allocationMinNetmaskLength)).setter(IpamPool.setter(Builder::allocationMinNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMinNetmaskLength").unmarshallLocationName("allocationMinNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MAX_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMaxNetmaskLength").getter(IpamPool.getter(IpamPool::allocationMaxNetmaskLength)).setter(IpamPool.setter(Builder::allocationMaxNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMaxNetmaskLength").unmarshallLocationName("allocationMaxNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationDefaultNetmaskLength").getter(IpamPool.getter(IpamPool::allocationDefaultNetmaskLength)).setter(IpamPool.setter(Builder::allocationDefaultNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationDefaultNetmaskLength").unmarshallLocationName("allocationDefaultNetmaskLength").build()}).build();
    private static final SdkField<List<IpamResourceTag>> ALLOCATION_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationResourceTags").getter(IpamPool.getter(IpamPool::allocationResourceTags)).setter(IpamPool.setter(Builder::allocationResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationResourceTagSet").unmarshallLocationName("allocationResourceTagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamPool.getter(IpamPool::tags)).setter(IpamPool.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsService").getter(IpamPool.getter(IpamPool::awsServiceAsString)).setter(IpamPool.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService").unmarshallLocationName("awsService").build()}).build();
    private static final SdkField<String> PUBLIC_IP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpSource").getter(IpamPool.getter(IpamPool::publicIpSourceAsString)).setter(IpamPool.setter(Builder::publicIpSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpSource").unmarshallLocationName("publicIpSource").build()}).build();
    private static final SdkField<IpamPoolSourceResource> SOURCE_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceResource").getter(IpamPool.getter(IpamPool::sourceResource)).setter(IpamPool.setter(Builder::sourceResource)).constructor(IpamPoolSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResource").unmarshallLocationName("sourceResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_POOL_ID_FIELD, SOURCE_IPAM_POOL_ID_FIELD, IPAM_POOL_ARN_FIELD, IPAM_SCOPE_ARN_FIELD, IPAM_SCOPE_TYPE_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, LOCALE_FIELD, POOL_DEPTH_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, DESCRIPTION_FIELD, AUTO_IMPORT_FIELD, PUBLICLY_ADVERTISABLE_FIELD, ADDRESS_FAMILY_FIELD, ALLOCATION_MIN_NETMASK_LENGTH_FIELD, ALLOCATION_MAX_NETMASK_LENGTH_FIELD, ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD, ALLOCATION_RESOURCE_TAGS_FIELD, TAGS_FIELD, AWS_SERVICE_FIELD, PUBLIC_IP_SOURCE_FIELD, SOURCE_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPool.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamPoolId;
    private final String sourceIpamPoolId;
    private final String ipamPoolArn;
    private final String ipamScopeArn;
    private final String ipamScopeType;
    private final String ipamArn;
    private final String ipamRegion;
    private final String locale;
    private final Integer poolDepth;
    private final String state;
    private final String stateMessage;
    private final String description;
    private final Boolean autoImport;
    private final Boolean publiclyAdvertisable;
    private final String addressFamily;
    private final Integer allocationMinNetmaskLength;
    private final Integer allocationMaxNetmaskLength;
    private final Integer allocationDefaultNetmaskLength;
    private final List<IpamResourceTag> allocationResourceTags;
    private final List<Tag> tags;
    private final String awsService;
    private final String publicIpSource;
    private final IpamPoolSourceResource sourceResource;

    private IpamPool(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamPoolId = builder.ipamPoolId;
        this.sourceIpamPoolId = builder.sourceIpamPoolId;
        this.ipamPoolArn = builder.ipamPoolArn;
        this.ipamScopeArn = builder.ipamScopeArn;
        this.ipamScopeType = builder.ipamScopeType;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.locale = builder.locale;
        this.poolDepth = builder.poolDepth;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.description = builder.description;
        this.autoImport = builder.autoImport;
        this.publiclyAdvertisable = builder.publiclyAdvertisable;
        this.addressFamily = builder.addressFamily;
        this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
        this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
        this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
        this.allocationResourceTags = builder.allocationResourceTags;
        this.tags = builder.tags;
        this.awsService = builder.awsService;
        this.publicIpSource = builder.publicIpSource;
        this.sourceResource = builder.sourceResource;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String sourceIpamPoolId() {
        return this.sourceIpamPoolId;
    }

    public final String ipamPoolArn() {
        return this.ipamPoolArn;
    }

    public final String ipamScopeArn() {
        return this.ipamScopeArn;
    }

    public final IpamScopeType ipamScopeType() {
        return IpamScopeType.fromValue(this.ipamScopeType);
    }

    public final String ipamScopeTypeAsString() {
        return this.ipamScopeType;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final String locale() {
        return this.locale;
    }

    public final Integer poolDepth() {
        return this.poolDepth;
    }

    public final IpamPoolState state() {
        return IpamPoolState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean autoImport() {
        return this.autoImport;
    }

    public final Boolean publiclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final Integer allocationMinNetmaskLength() {
        return this.allocationMinNetmaskLength;
    }

    public final Integer allocationMaxNetmaskLength() {
        return this.allocationMaxNetmaskLength;
    }

    public final Integer allocationDefaultNetmaskLength() {
        return this.allocationDefaultNetmaskLength;
    }

    public final boolean hasAllocationResourceTags() {
        return this.allocationResourceTags != null && !(this.allocationResourceTags instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceTag> allocationResourceTags() {
        return this.allocationResourceTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IpamPoolAwsService awsService() {
        return IpamPoolAwsService.fromValue(this.awsService);
    }

    public final String awsServiceAsString() {
        return this.awsService;
    }

    public final IpamPoolPublicIpSource publicIpSource() {
        return IpamPoolPublicIpSource.fromValue(this.publicIpSource);
    }

    public final String publicIpSourceAsString() {
        return this.publicIpSource;
    }

    public final IpamPoolSourceResource sourceResource() {
        return this.sourceResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAdvertisable());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMinNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMaxNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationResourceTags() ? this.allocationResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsServiceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPool)) {
            return false;
        }
        IpamPool other = (IpamPool)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.sourceIpamPoolId(), other.sourceIpamPoolId()) && Objects.equals(this.ipamPoolArn(), other.ipamPoolArn()) && Objects.equals(this.ipamScopeArn(), other.ipamScopeArn()) && Objects.equals(this.ipamScopeTypeAsString(), other.ipamScopeTypeAsString()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.poolDepth(), other.poolDepth()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoImport(), other.autoImport()) && Objects.equals(this.publiclyAdvertisable(), other.publiclyAdvertisable()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.allocationMinNetmaskLength(), other.allocationMinNetmaskLength()) && Objects.equals(this.allocationMaxNetmaskLength(), other.allocationMaxNetmaskLength()) && Objects.equals(this.allocationDefaultNetmaskLength(), other.allocationDefaultNetmaskLength()) && this.hasAllocationResourceTags() == other.hasAllocationResourceTags() && Objects.equals(this.allocationResourceTags(), other.allocationResourceTags()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.awsServiceAsString(), other.awsServiceAsString()) && Objects.equals(this.publicIpSourceAsString(), other.publicIpSourceAsString()) && Objects.equals(this.sourceResource(), other.sourceResource());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPool").add("OwnerId", (Object)this.ownerId()).add("IpamPoolId", (Object)this.ipamPoolId()).add("SourceIpamPoolId", (Object)this.sourceIpamPoolId()).add("IpamPoolArn", (Object)this.ipamPoolArn()).add("IpamScopeArn", (Object)this.ipamScopeArn()).add("IpamScopeType", (Object)this.ipamScopeTypeAsString()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("Locale", (Object)this.locale()).add("PoolDepth", (Object)this.poolDepth()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("Description", (Object)this.description()).add("AutoImport", (Object)this.autoImport()).add("PubliclyAdvertisable", (Object)this.publiclyAdvertisable()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("AllocationMinNetmaskLength", (Object)this.allocationMinNetmaskLength()).add("AllocationMaxNetmaskLength", (Object)this.allocationMaxNetmaskLength()).add("AllocationDefaultNetmaskLength", (Object)this.allocationDefaultNetmaskLength()).add("AllocationResourceTags", this.hasAllocationResourceTags() ? this.allocationResourceTags() : null).add("Tags", this.hasTags() ? this.tags() : null).add("AwsService", (Object)this.awsServiceAsString()).add("PublicIpSource", (Object)this.publicIpSourceAsString()).add("SourceResource", (Object)this.sourceResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "SourceIpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.sourceIpamPoolId()));
            }
            case "IpamPoolArn": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolArn()));
            }
            case "IpamScopeArn": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeArn()));
            }
            case "IpamScopeType": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeTypeAsString()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "PoolDepth": {
                return Optional.ofNullable(clazz.cast(this.poolDepth()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AutoImport": {
                return Optional.ofNullable(clazz.cast(this.autoImport()));
            }
            case "PubliclyAdvertisable": {
                return Optional.ofNullable(clazz.cast(this.publiclyAdvertisable()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "AllocationMinNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMinNetmaskLength()));
            }
            case "AllocationMaxNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMaxNetmaskLength()));
            }
            case "AllocationDefaultNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationDefaultNetmaskLength()));
            }
            case "AllocationResourceTags": {
                return Optional.ofNullable(clazz.cast(this.allocationResourceTags()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AwsService": {
                return Optional.ofNullable(clazz.cast(this.awsServiceAsString()));
            }
            case "PublicIpSource": {
                return Optional.ofNullable(clazz.cast(this.publicIpSourceAsString()));
            }
            case "SourceResource": {
                return Optional.ofNullable(clazz.cast(this.sourceResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("IpamPoolId", IPAM_POOL_ID_FIELD);
        map.put("SourceIpamPoolId", SOURCE_IPAM_POOL_ID_FIELD);
        map.put("IpamPoolArn", IPAM_POOL_ARN_FIELD);
        map.put("IpamScopeArn", IPAM_SCOPE_ARN_FIELD);
        map.put("IpamScopeType", IPAM_SCOPE_TYPE_FIELD);
        map.put("IpamArn", IPAM_ARN_FIELD);
        map.put("IpamRegion", IPAM_REGION_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("PoolDepth", POOL_DEPTH_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AutoImport", AUTO_IMPORT_FIELD);
        map.put("PubliclyAdvertisable", PUBLICLY_ADVERTISABLE_FIELD);
        map.put("AddressFamily", ADDRESS_FAMILY_FIELD);
        map.put("AllocationMinNetmaskLength", ALLOCATION_MIN_NETMASK_LENGTH_FIELD);
        map.put("AllocationMaxNetmaskLength", ALLOCATION_MAX_NETMASK_LENGTH_FIELD);
        map.put("AllocationDefaultNetmaskLength", ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD);
        map.put("AllocationResourceTagSet", ALLOCATION_RESOURCE_TAGS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("AwsService", AWS_SERVICE_FIELD);
        map.put("PublicIpSource", PUBLIC_IP_SOURCE_FIELD);
        map.put("SourceResource", SOURCE_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPool, T> g) {
        return obj -> g.apply((IpamPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamPoolId;
        private String sourceIpamPoolId;
        private String ipamPoolArn;
        private String ipamScopeArn;
        private String ipamScopeType;
        private String ipamArn;
        private String ipamRegion;
        private String locale;
        private Integer poolDepth;
        private String state;
        private String stateMessage;
        private String description;
        private Boolean autoImport;
        private Boolean publiclyAdvertisable;
        private String addressFamily;
        private Integer allocationMinNetmaskLength;
        private Integer allocationMaxNetmaskLength;
        private Integer allocationDefaultNetmaskLength;
        private List<IpamResourceTag> allocationResourceTags = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String awsService;
        private String publicIpSource;
        private IpamPoolSourceResource sourceResource;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPool model) {
            this.ownerId(model.ownerId);
            this.ipamPoolId(model.ipamPoolId);
            this.sourceIpamPoolId(model.sourceIpamPoolId);
            this.ipamPoolArn(model.ipamPoolArn);
            this.ipamScopeArn(model.ipamScopeArn);
            this.ipamScopeType(model.ipamScopeType);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.locale(model.locale);
            this.poolDepth(model.poolDepth);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.description(model.description);
            this.autoImport(model.autoImport);
            this.publiclyAdvertisable(model.publiclyAdvertisable);
            this.addressFamily(model.addressFamily);
            this.allocationMinNetmaskLength(model.allocationMinNetmaskLength);
            this.allocationMaxNetmaskLength(model.allocationMaxNetmaskLength);
            this.allocationDefaultNetmaskLength(model.allocationDefaultNetmaskLength);
            this.allocationResourceTags(model.allocationResourceTags);
            this.tags(model.tags);
            this.awsService(model.awsService);
            this.publicIpSource(model.publicIpSource);
            this.sourceResource(model.sourceResource);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getSourceIpamPoolId() {
            return this.sourceIpamPoolId;
        }

        public final void setSourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
        }

        @Override
        public final Builder sourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        public final String getIpamPoolArn() {
            return this.ipamPoolArn;
        }

        public final void setIpamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
        }

        @Override
        public final Builder ipamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
            return this;
        }

        public final String getIpamScopeArn() {
            return this.ipamScopeArn;
        }

        public final void setIpamScopeArn(String ipamScopeArn) {
            this.ipamScopeArn = ipamScopeArn;
        }

        @Override
        public final Builder ipamScopeArn(String ipamScopeArn) {
            this.ipamScopeArn = ipamScopeArn;
            return this;
        }

        public final String getIpamScopeType() {
            return this.ipamScopeType;
        }

        public final void setIpamScopeType(String ipamScopeType) {
            this.ipamScopeType = ipamScopeType;
        }

        @Override
        public final Builder ipamScopeType(String ipamScopeType) {
            this.ipamScopeType = ipamScopeType;
            return this;
        }

        @Override
        public final Builder ipamScopeType(IpamScopeType ipamScopeType) {
            this.ipamScopeType(ipamScopeType == null ? null : ipamScopeType.toString());
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final Integer getPoolDepth() {
            return this.poolDepth;
        }

        public final void setPoolDepth(Integer poolDepth) {
            this.poolDepth = poolDepth;
        }

        @Override
        public final Builder poolDepth(Integer poolDepth) {
            this.poolDepth = poolDepth;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPoolState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoImport() {
            return this.autoImport;
        }

        public final void setAutoImport(Boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public final Builder autoImport(Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        public final Boolean getPubliclyAdvertisable() {
            return this.publiclyAdvertisable;
        }

        public final void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
        }

        @Override
        public final Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final Integer getAllocationMinNetmaskLength() {
            return this.allocationMinNetmaskLength;
        }

        public final void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
        }

        @Override
        public final Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        public final Integer getAllocationMaxNetmaskLength() {
            return this.allocationMaxNetmaskLength;
        }

        public final void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
        }

        @Override
        public final Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        public final Integer getAllocationDefaultNetmaskLength() {
            return this.allocationDefaultNetmaskLength;
        }

        public final void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
        }

        @Override
        public final Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        public final List<IpamResourceTag.Builder> getAllocationResourceTags() {
            List<IpamResourceTag.Builder> result = IpamResourceTagListCopier.copyToBuilder(this.allocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationResourceTags(Collection<IpamResourceTag.BuilderImpl> allocationResourceTags) {
            this.allocationResourceTags = IpamResourceTagListCopier.copyFromBuilder(allocationResourceTags);
        }

        @Override
        public final Builder allocationResourceTags(Collection<IpamResourceTag> allocationResourceTags) {
            this.allocationResourceTags = IpamResourceTagListCopier.copy(allocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationResourceTags(IpamResourceTag ... allocationResourceTags) {
            this.allocationResourceTags(Arrays.asList(allocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationResourceTags(Consumer<IpamResourceTag.Builder> ... allocationResourceTags) {
            this.allocationResourceTags(Stream.of(allocationResourceTags).map(c -> (IpamResourceTag)((IpamResourceTag.Builder)IpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        @Override
        public final Builder awsService(IpamPoolAwsService awsService) {
            this.awsService(awsService == null ? null : awsService.toString());
            return this;
        }

        public final String getPublicIpSource() {
            return this.publicIpSource;
        }

        public final void setPublicIpSource(String publicIpSource) {
            this.publicIpSource = publicIpSource;
        }

        @Override
        public final Builder publicIpSource(String publicIpSource) {
            this.publicIpSource = publicIpSource;
            return this;
        }

        @Override
        public final Builder publicIpSource(IpamPoolPublicIpSource publicIpSource) {
            this.publicIpSource(publicIpSource == null ? null : publicIpSource.toString());
            return this;
        }

        public final IpamPoolSourceResource.Builder getSourceResource() {
            return this.sourceResource != null ? this.sourceResource.toBuilder() : null;
        }

        public final void setSourceResource(IpamPoolSourceResource.BuilderImpl sourceResource) {
            this.sourceResource = sourceResource != null ? sourceResource.build() : null;
        }

        @Override
        public final Builder sourceResource(IpamPoolSourceResource sourceResource) {
            this.sourceResource = sourceResource;
            return this;
        }

        public IpamPool build() {
            return new IpamPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPool> {
        public Builder ownerId(String var1);

        public Builder ipamPoolId(String var1);

        public Builder sourceIpamPoolId(String var1);

        public Builder ipamPoolArn(String var1);

        public Builder ipamScopeArn(String var1);

        public Builder ipamScopeType(String var1);

        public Builder ipamScopeType(IpamScopeType var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder locale(String var1);

        public Builder poolDepth(Integer var1);

        public Builder state(String var1);

        public Builder state(IpamPoolState var1);

        public Builder stateMessage(String var1);

        public Builder description(String var1);

        public Builder autoImport(Boolean var1);

        public Builder publiclyAdvertisable(Boolean var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder allocationMinNetmaskLength(Integer var1);

        public Builder allocationMaxNetmaskLength(Integer var1);

        public Builder allocationDefaultNetmaskLength(Integer var1);

        public Builder allocationResourceTags(Collection<IpamResourceTag> var1);

        public Builder allocationResourceTags(IpamResourceTag ... var1);

        public Builder allocationResourceTags(Consumer<IpamResourceTag.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder awsService(String var1);

        public Builder awsService(IpamPoolAwsService var1);

        public Builder publicIpSource(String var1);

        public Builder publicIpSource(IpamPoolPublicIpSource var1);

        public Builder sourceResource(IpamPoolSourceResource var1);

        default public Builder sourceResource(Consumer<IpamPoolSourceResource.Builder> sourceResource) {
            return this.sourceResource((IpamPoolSourceResource)((IpamPoolSourceResource.Builder)IpamPoolSourceResource.builder().applyMutation(sourceResource)).build());
        }
    }
}

