/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.util.HashMap;
import java.util.Map;

public enum TrustFlags {
    NZTF_SERVER_AUTH("SERVER_AUTH", "C", 1),
    NZTF_CLIENT_AUTH("CLIENT_AUTH", "T", 2),
    NZTF_VALID_PEER("VALID_PEER", "P", 4),
    NZTF_USER_CERT("USER_CERT", "U", 8),
    NZTF_NULL("NULL", "NULL", 16),
    NZTF_TRUSTED("TRUSTED", "TRUSTED", 32),
    NZTF_NONE("NONE", "NONE", 64);

    private final String a;
    private final String b;
    private final byte c;
    private static final Map<String, TrustFlags> d;

    private TrustFlags(String string2, String string3, byte by) {
        this.a = string2;
        this.c = by;
        this.b = string3;
    }

    public byte getTrustFlagValue() {
        return this.c;
    }

    public static byte calculateTrustFlagsByteValue(String string) {
        byte by = 0;
        TrustFlags trustFlags = null;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            trustFlags = d.get(stringArray[i]);
            if (trustFlags == null) {
                by = 0;
                break;
            }
            by = (byte)(by | trustFlags.getTrustFlagValue());
        }
        return by;
    }

    public static String calculateTrustFlagsStringValue(byte by) {
        String string = "";
        for (TrustFlags trustFlags : TrustFlags.values()) {
            if ((by & trustFlags.getTrustFlagValue()) == 0) continue;
            string = string.concat(trustFlags.getDisplayName() + ",");
        }
        if (string.endsWith(",") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getDisplayName() {
        return this.a;
    }

    public String getShortName() {
        return this.b;
    }

    static {
        d = new HashMap<String, TrustFlags>();
        for (TrustFlags trustFlags : TrustFlags.values()) {
            d.put(trustFlags.getDisplayName(), trustFlags);
        }
    }
}

