# SLA, chapter 6
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("sla06.tst");

# doc/manual.xml:1771-1783
gap> L:= SimpleLieAlgebra("E",7,Rationals);;                
gap> K:= Subalgebra( L, [ L.1,L.3,L.4,L.5,L.6,L.7,L.63,               
> L.64,L.66,L.67,L.68,L.69,L.70,L.126] );;
gap> Dimension(K);
63
gap> SemiSimpleType(K);
"A7"
gap> ProjectionMatrix( L, K );
[ [ 2, 2, 3, 4, 3, 2, 1 ], [ 0, 0, -1, 0, 0, 0, 0 ], [ 0, 0, 0, -1, 0, 0, 0 ],
  [ 0, 0, 0, 0, -1, 0, 0 ], [ 0, 0, 0, 0, 0, -1, 0 ], 
  [ 0, 0, 0, 0, 0, 0, -1 ], [ -1, -2, -2, -3, -2, -1, 0 ] ]

# doc/manual.xml:1809-1834
gap> L:= SimpleLieAlgebra("E",7,Rationals);;                
gap> K:= Subalgebra( L, [ L.1,L.3,L.4,L.5,L.6,L.7,L.63,               
> L.64,L.66,L.67,L.68,L.69,L.70,L.126] );;
gap> Branching( L, K, [1,0,0,0,0,0,1] );
[ [ [ 1, 1, 0, 0, 0, 0, 1 ], [ 1, 1, 1, 0, 0, 0, 0 ], [ 0, 0, 0, 0, 1, 0, 1 ],
      [ 0, 0, 1, 0, 1, 0, 0 ], [ 1, 0, 0, 1, 0, 0, 0 ], 
      [ 0, 1, 0, 0, 0, 1, 0 ], [ 0, 0, 0, 0, 0, 0, 1 ], 
      [ 0, 0, 1, 0, 0, 0, 0 ] ], [ 1, 1, 1, 1, 1, 1, 1, 1 ] ]
gap> L:= SimpleLieAlgebra("E",7,Rationals);;
gap> r:= RegularSemisimpleSubalgebras(L);;
gap> K:= Filtered( r, M -> SemiSimpleType(M)="E6" )[1];
<Lie algebra of dimension 78 over Rationals>
gap> cc:= BasisVectors( Basis( LieCentralizer( L, K ) ) );
[ v.127+(3/2)*v.128+(2)*v.129+(3)*v.130+(5/2)*v.131+(2)*v.132+(3/2)*v.133 ]
gap> Branching( L, K, cc, [1,0,0,0,0,0,1] );
[ [ [ 0, 0, 0, 0, 0, 2, -1/2 ], [ 1, 1, 0, 0, 0, 0, -1/2 ], 
      [ 0, 0, 0, 0, 1, 0, -1/2 ], [ 1, 0, 0, 0, 0, 0, 5/2 ], 
      [ 0, 1, 0, 0, 0, 1, 1/2 ], [ 2, 0, 0, 0, 0, 0, 1/2 ], 
      [ 0, 0, 1, 0, 0, 0, 1/2 ], [ 0, 0, 0, 0, 0, 1, -5/2 ], 
      [ 1, 0, 0, 0, 0, 1, -3/2 ], [ 1, 0, 0, 0, 0, 1, 3/2 ], 
      [ 0, 1, 0, 0, 0, 0, 3/2 ], [ 0, 1, 0, 0, 0, 0, -3/2 ], 
      [ 0, 0, 0, 0, 0, 0, 3/2 ], [ 0, 0, 0, 0, 0, 0, -3/2 ], 
      [ 0, 0, 0, 0, 0, 1, 1/2 ], [ 1, 0, 0, 0, 0, 0, -1/2 ] ], 
  [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2 ] ]      

# doc/manual.xml:1854-1868
gap> L:= SimpleLieAlgebra("E",6,Rationals);;
gap> K:= RegularSemisimpleSubalgebras( L );;
gap> Length(K);
19
gap> K[5];
<Lie algebra of dimension 45 over Rationals>
gap> SemiSimpleType( K[5] ); 
"D5"
gap> Branching( L, K[5], [1,0,0,0,0,1] );     
[ [ [ 1, 0, 0, 0, 0 ], [ 0, 0, 0, 1, 1 ], [ 1, 0, 0, 1, 0 ], 
      [ 1, 0, 0, 0, 1 ], [ 2, 0, 0, 0, 0 ], [ 0, 0, 0, 1, 0 ], 
      [ 0, 0, 0, 0, 1 ], [ 0, 1, 0, 0, 0 ], [ 0, 0, 0, 0, 0 ] ], 
  [ 2, 1, 1, 1, 1, 1, 1, 1, 1 ] ]

# doc/manual.xml:1932-1956
# Semisimple subalgebras of the Lie algebra of type D4:
gap> s:= LieAlgebraAndSubalgebras( "D4" );;
gap> L:= s.liealg;
<Lie algebra of dimension 28 over CF(3)>
gap> sub:= s.subalgs;;
gap> Length(sub);
44
gap> g:= InclusionsGraph( "D4" );;
gap> g[1];
[ 12, 1 ]

# Find the maximal semisimple subalgebras:
gap> m:= Filtered( g, x -> x[1]=0 );; i:= List( m, x -> x[2] );
[ 13, 35, 36, 37, 41, 42, 43, 44 ]
gap> List( sub{i}, SemiSimpleType );                
[ "A2", "A1 B2", "A1 B2", "A1 B2", "B3", "B3", "B3", "A1 A1 A1 A1" ]

# We see that the subalgebras on positions 35 and 36 are isomorphic;
# however they are not linearly equivalent:
gap> Branching( L, sub[35], [0,0,1,0] );
[ [ [ 1, 0, 1 ] ], [ 1 ] ]
gap> Branching( L, sub[36], [0,0,1,0] );
[ [ [ 0, 1, 0 ], [ 2, 0, 0 ] ], [ 1, 1 ] ]

# doc/manual.xml:1970-1986
gap> s:= LieAlgebraAndSubalgebras( "C3" );;
gap> g:= InclusionsGraph( "C3" );
[ [ 10, 1 ], [ 11, 1 ], [ 12, 1 ], [ 8, 2 ], [ 10, 2 ], [ 11, 2 ], [ 11, 3 ], 
  [ 13, 3 ], [ 8, 4 ], [ 13, 4 ], [ 9, 5 ], [ 12, 5 ], [ 12, 6 ], [ 13, 6 ], 
  [ 0, 7 ], [ 0, 8 ], [ 15, 9 ], [ 9, 10 ], [ 14, 10 ], [ 14, 11 ], 
  [ 15, 12 ], [ 0, 13 ], [ 15, 14 ], [ 0, 15 ] ]
gap> # there are the edges [ 14, 10] and [ 10, 2 ]; hence a conjugate of the
gap> # second algebra is contained in the 14-th.
gap> L:= s.liealg;
<Lie algebra of dimension 21 over Rationals>
gap> sub:= s.subalgs;;
gap> K:=SubalgebrasInclusion( L, sub[2], sub[14] );
<Lie algebra of dimension 3 over Rationals>
gap> Basis(K)[1] in sub[14];
true

# doc/manual.xml:2008-2020
gap> s:= LieAlgebraAndSubalgebras( "C7" );;
gap> g:= InclusionsGraph( "C7" );;
gap> m:= Filtered( g, x -> x[1]=0 );; i:= List( m, x -> x[2] );
[ 63, 498, 665, 804, 819, 821, 822 ]
gap> L:= s.liealg;
<Lie algebra of dimension 105 over Rationals>
gap> sub:= s.subalgs;;
gap> List( sub{i}, SemiSimpleType );   
[ "A1", "C3", "A1 B3", "A6", "C3 C4", "B2 C5", "A1 C6" ]
gap> DynkinIndex( sub[665], L );   
[ 7, 4 ]

# doc/manual.xml:2039-2052
# Lets find the subalgebras in the database for C5 that are linearly
# equivalent to regular subalgebras:
gap> s:= LieAlgebraAndSubalgebras("C5");; L:= s.liealg; sub:= s.subalgs;;
<Lie algebra of dimension 55 over Rationals>
gap> reg:= RegularSemisimpleSubalgebras( L );;
gap> posn:= [];;
gap> for K in reg do  
> Add(posn,PositionProperty(sub,M -> AreLinearlyEquivalentSubalgebras(L,M,K)));
> od;
gap> posn;
[ 2, 24, 93, 111, 105, 82, 106, 81, 41, 109, 70, 85, 29, 112, 94, 25, 1, 118, 
  100, 102, 64, 108, 84, 28, 117, 107, 116, 96, 101, 63, 115, 114, 95, 113 ]

# doc/manual.xml:2079-2083
gap> r:= LieAlgebraAndSubalgebras( "A2 B2" );;
gap> d:= MakeDatabaseEntry( r );;
gap> PrintTo( "A2B2", "d:= ",d,";\n");

# doc/manual.xml:2114-2125
gap> R:= RootSystem("F",4);
<root system of type F4>
gap> c:= ClosedSubsets(R);;
gap> Length(c);
4844
gap> c[1005];
[ [ 1, 1, 0, 0 ], [ 0, 0, 1, 1 ], [ 0, 1, 2, 0 ], [ 0, 1, 1, 1 ], 
  [ 1, 1, 1, 1 ], [ 1, 2, 2, 0 ], [ 1, 1, 2, 1 ], [ 0, 1, 2, 2 ], 
  [ 1, 1, 2, 2 ], [ 1, 2, 3, 1 ], [ 1, 2, 2, 2 ], [ 1, 2, 3, 2 ], 
  [ 1, 2, 4, 2 ], [ 1, 3, 4, 2 ], [ 2, 3, 4, 2 ], [ 0, -1, -2, 0 ] ]

# doc/manual.xml:2144-2154
gap> R:= RootSystem("F",4);
<root system of type F4>
gap> c:= ClosedSubsets(R);;
gap> DecompositionOfClosedSet( c[1005] );
[ [ [ 0, 1, 2, 0 ], [ 0, -1, -2, 0 ] ], 
  [ [ 1, 1, 0, 0 ], [ 0, 0, 1, 1 ], [ 0, 1, 1, 1 ], [ 1, 1, 1, 1 ], 
      [ 1, 2, 2, 0 ], [ 1, 1, 2, 1 ], [ 0, 1, 2, 2 ], [ 1, 1, 2, 2 ], 
      [ 1, 2, 3, 1 ], [ 1, 2, 2, 2 ], [ 1, 2, 3, 2 ], [ 1, 2, 4, 2 ], 
      [ 1, 3, 4, 2 ], [ 2, 3, 4, 2 ] ] ]

# doc/manual.xml:2171-2181
gap> R:= RootSystem("F",4);
<root system of type F4>
gap> c:= ClosedSubsets(R);;
gap> IsSpecialClosedSet( c[1005] );
false
gap> IsSpecialClosedSet( c[1006] );
true
gap> Length( Filtered( c, IsSpecialClosedSet ) );
3579

# doc/manual.xml:2198-2215
gap> L:= SimpleLieAlgebra("F",4,Rationals);
<Lie algebra of dimension 52 over Rationals>
gap> R:= RootSystem( L );
<root system of rank 4>
gap> c:= ClosedSubsets(R);; 
gap> c[1005];
[ [ 1, 0, 1, 0 ], [ 0, 1, 0, 1 ], [ 1, 0, 1, 1 ], [ 0, 0, 2, 1 ], 
  [ 1, 1, 1, 1 ], [ 1, 1, 2, 1 ], [ 2, 0, 2, 1 ], [ 0, 1, 2, 2 ], 
  [ 2, 1, 2, 1 ], [ 1, 1, 3, 2 ], [ 2, 1, 2, 2 ], [ 2, 1, 3, 2 ], 
  [ 2, 1, 4, 2 ], [ 2, 1, 4, 3 ], [ 2, 2, 4, 3 ], [ 0, 0, -2, -1 ] ]
gap> K:= SubalgebraOfClosedSet( L, c[1005] );
<Lie algebra of dimension 20 over Rationals>
gap> LeviMalcevDecomposition(K);
[ <Lie algebra of dimension 3 over Rationals>, 
  <two-sided ideal in <Lie algebra of dimension 20 over Rationals>, 
      (dimension 17)> ]

#
gap> STOP_TEST("sla06.tst", 1);
