/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSourceInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;

public class GenericPrimaryKeyManager
extends SQLConstraintManager<GenericUniqueKey, GenericTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericUniqueKey> getObjectsCache(GenericUniqueKey object) {
        return ((GenericStructContainer)((GenericTableBase)object.getParentObject()).getContainer()).getConstraintKeysCache();
    }

    public boolean canCreateObject(@NotNull Object container) {
        return container instanceof GenericTable && (!(((GenericDataSource)((GenericTable)((Object)container)).getDataSource()).getInfo() instanceof GenericDataSourceInfo) || ((GenericDataSourceInfo)((GenericDataSource)((GenericTable)((Object)container)).getDataSource()).getInfo()).supportsTableConstraints()) && GenericUtils.canAlterTable((DBSObject)((GenericTable)((Object)container)));
    }

    public boolean canEditObject(@NotNull GenericUniqueKey object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    public boolean canDeleteObject(@NotNull GenericUniqueKey object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    protected GenericUniqueKey createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)((Object)container);
        return ((GenericDataSource)tableBase.getDataSource()).getMetaModel().createConstraintImpl(tableBase, "new_key", DBSEntityConstraintType.PRIMARY_KEY, null, false);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        GenericUniqueKey key = (GenericUniqueKey)command.getObject();
        if (key.getConstraintType() == DBSEntityConstraintType.CHECK && key instanceof DBSTableCheckConstraint) {
            DBSTableCheckConstraint check = (DBSTableCheckConstraint)key;
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + ((GenericTableBase)key.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)key) + " CHECK (" + check.getCheckConstraintDefinition() + ")"));
        } else {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
    }

    protected boolean isLegacyConstraintsSyntax(GenericTableBase owner) {
        return GenericUtils.isLegacySQLDialect((DBSObject)owner);
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<GenericUniqueKey> command) {
        GenericUniqueKey object = (GenericUniqueKey)command.getObject();
        if (object.getConstraintType() == DBSEntityConstraintType.CHECK && object instanceof DBSTableCheckConstraint) {
            DBSTableCheckConstraint check = (DBSTableCheckConstraint)object;
            decl.append("(").append(check.getCheckConstraintDefinition()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }
}

