/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.swt.internal.gtk;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.EventHandler;

public class DarkThemeProcessor {
    @Inject
    IEventBroker eventBroker;
    private EventHandler eventHandler;

    @PostConstruct
    public void intialize() {
        this.eventHandler = event -> {
            if (event == null) {
                return;
            }
            ITheme theme = (ITheme)event.getProperty("theme");
            boolean isDark = theme.getId().contains("dark");
            Display display = (Display)event.getProperty("device");
            display.asyncExec(() -> OS.setDarkThemePreferred((boolean)isDark));
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", this.eventHandler);
    }

    @PreDestroy
    public void cleanUp() {
        this.eventBroker.unsubscribe(this.eventHandler);
    }
}

