/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

public class Limit {
    private static final Map<ICounter.CounterValue, String> VALUE_NAMES;
    private static final Map<ICoverageNode.CounterEntity, String> ENTITY_NAMES;
    private ICoverageNode.CounterEntity entity = ICoverageNode.CounterEntity.INSTRUCTION;
    private ICounter.CounterValue value = ICounter.CounterValue.COVEREDRATIO;
    private BigDecimal minimum;
    private BigDecimal maximum;

    public ICoverageNode.CounterEntity getEntity() {
        return this.entity;
    }

    public void setCounter(String entity) {
        this.entity = ICoverageNode.CounterEntity.valueOf((String)entity);
    }

    public ICounter.CounterValue getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = ICounter.CounterValue.valueOf((String)value);
    }

    public String getMinimum() {
        return this.minimum == null ? null : this.minimum.toPlainString();
    }

    public void setMinimum(String minimum) {
        this.minimum = Limit.parseValue(minimum);
    }

    public String getMaximum() {
        return this.maximum == null ? null : this.maximum.toPlainString();
    }

    public void setMaximum(String maximum) {
        this.maximum = Limit.parseValue(maximum);
    }

    private static BigDecimal parseValue(String value) {
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.endsWith("%")) {
            String percent = trimmedValue.substring(0, trimmedValue.length() - 1);
            return new BigDecimal(percent).movePointLeft(2);
        }
        return new BigDecimal(trimmedValue);
    }

    String check(ICoverageNode node) {
        String msg = this.checkRatioLimit();
        if (msg != null) {
            return msg;
        }
        double d = node.getCounter(this.entity).getValue(this.value);
        if (Double.isNaN(d)) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(d);
        if (this.minimum != null && this.minimum.compareTo(bd) > 0) {
            return this.message("minimum", bd, this.minimum, RoundingMode.FLOOR);
        }
        if (this.maximum != null && this.maximum.compareTo(bd) < 0) {
            return this.message("maximum", bd, this.maximum, RoundingMode.CEILING);
        }
        return null;
    }

    private String message(String minmax, BigDecimal v, BigDecimal ref, RoundingMode mode) {
        BigDecimal rounded = v.setScale(ref.scale(), mode);
        return String.format("%s %s is %s, but expected %s is %s", ENTITY_NAMES.get(this.entity), VALUE_NAMES.get(this.value), rounded.toPlainString(), minmax, ref.toPlainString());
    }

    private String checkRatioLimit() {
        if (ICounter.CounterValue.MISSEDRATIO.equals((Object)this.value) || ICounter.CounterValue.COVEREDRATIO.equals((Object)this.value)) {
            String minmsg = this.checkRatioLimit("minimum", this.minimum);
            if (minmsg != null) {
                return minmsg;
            }
            String maxmsg = this.checkRatioLimit("maximum", this.maximum);
            if (maxmsg != null) {
                return maxmsg;
            }
        }
        return null;
    }

    private String checkRatioLimit(String minmax, BigDecimal v) {
        if (v != null && (v.compareTo(BigDecimal.ZERO) < 0 || v.compareTo(BigDecimal.ONE) > 0)) {
            return String.format("given %s ratio is %s, but must be between 0.0 and 1.0", minmax, v);
        }
        return null;
    }

    static {
        HashMap<ICounter.CounterValue, String> values = new HashMap<ICounter.CounterValue, String>();
        values.put(ICounter.CounterValue.TOTALCOUNT, "total count");
        values.put(ICounter.CounterValue.MISSEDCOUNT, "missed count");
        values.put(ICounter.CounterValue.COVEREDCOUNT, "covered count");
        values.put(ICounter.CounterValue.MISSEDRATIO, "missed ratio");
        values.put(ICounter.CounterValue.COVEREDRATIO, "covered ratio");
        VALUE_NAMES = Collections.unmodifiableMap(values);
        HashMap<ICoverageNode.CounterEntity, String> entities = new HashMap<ICoverageNode.CounterEntity, String>();
        entities.put(ICoverageNode.CounterEntity.INSTRUCTION, "instructions");
        entities.put(ICoverageNode.CounterEntity.BRANCH, "branches");
        entities.put(ICoverageNode.CounterEntity.COMPLEXITY, "complexity");
        entities.put(ICoverageNode.CounterEntity.LINE, "lines");
        entities.put(ICoverageNode.CounterEntity.METHOD, "methods");
        entities.put(ICoverageNode.CounterEntity.CLASS, "classes");
        ENTITY_NAMES = Collections.unmodifiableMap(entities);
    }
}

