/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private final ResourceBundle bundle;
    private final Locale locale;
    private static final Map<String, StringManager> managers = new HashMap<String, StringManager>();

    private StringManager(String string) {
        ResourceBundle resourceBundle;
        block4: {
            String string2 = string + ".LocalStrings";
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault());
            }
            catch (MissingResourceException missingResourceException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) break block4;
                try {
                    resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
        }
        this.locale = resourceBundle != null ? resourceBundle.getLocale() : null;
        this.bundle = resourceBundle;
    }

    public String getString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key may not have a null value");
        }
        String string2 = null;
        try {
            if (this.bundle != null) {
                string2 = this.bundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public String getString(String string, Object ... objectArray) {
        String string2 = this.getString(string);
        if (string2 == null) {
            string2 = string;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        messageFormat.setLocale(this.locale);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static synchronized StringManager getManager(String string) {
        StringManager stringManager = managers.get(string);
        if (stringManager == null) {
            stringManager = new StringManager(string);
            managers.put(string, stringManager);
        }
        return stringManager;
    }

    public static StringManager getManager(Class<?> clazz) {
        return StringManager.getManager(clazz.getPackage().getName());
    }
}

