/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.util.GenericName;

public final class StoreUtilities
extends Static {
    public static final Logger LOGGER = Logging.getLogger("org.apache.sis.storage");
    private static final Set<String> basedOnASCII = JDK9.setOf("US-ASCII", "ISO-8859-1", "UTF-8");

    private StoreUtilities() {
    }

    public static String getFormatName(DataStoreProvider dataStoreProvider) {
        if (dataStoreProvider != null) {
            StoreMetadata storeMetadata = dataStoreProvider.getClass().getAnnotation(StoreMetadata.class);
            if (storeMetadata != null) {
                return storeMetadata.formatName();
            }
            return dataStoreProvider.getShortName();
        }
        return null;
    }

    private static String getAnyIdentifier(Metadata metadata, boolean bl) {
        String string = null;
        if (metadata != null) {
            for (Identification identification : metadata.getIdentificationInfo()) {
                String string2 = Identifiers.getIdentifier((Citation)identification.getCitation(), (boolean)bl);
                if (string2 == null) continue;
                if (identification instanceof DataIdentification) {
                    return string2;
                }
                if (string != null) continue;
                string = string2;
            }
        }
        return string;
    }

    public static String getLabel(Resource resource) throws DataStoreException {
        String string = null;
        if (resource instanceof DataStore) {
            string = ((DataStore)resource).getDisplayName();
        }
        if (string == null) {
            Optional<GenericName> optional = resource.getIdentifier();
            if (optional.isPresent()) {
                string = optional.get().toString();
            } else {
                string = StoreUtilities.getAnyIdentifier(resource.getMetadata(), false);
                if (string == null) {
                    string = Classes.getShortName(StoreUtilities.getInterface(resource.getClass()));
                }
            }
        }
        return string;
    }

    public static Envelope getEnvelope(Metadata metadata) {
        GeneralEnvelope generalEnvelope = null;
        if (metadata != null) {
            for (Identification identification : metadata.getIdentificationInfo()) {
                if (!(identification instanceof AbstractIdentification)) continue;
                for (Extent extent : ((AbstractIdentification)identification).getExtents()) {
                    for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                        if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                        GeneralEnvelope generalEnvelope2 = new GeneralEnvelope((GeographicBoundingBox)geographicExtent);
                        if (generalEnvelope == null) {
                            generalEnvelope = generalEnvelope2;
                            continue;
                        }
                        generalEnvelope.add((Envelope)generalEnvelope2);
                    }
                }
            }
        }
        return generalEnvelope;
    }

    public static Class<? extends Resource> getInterface(Class<? extends Resource> clazz) {
        Class<Resource>[] classArray = Classes.getLeafInterfaces(clazz, Resource.class);
        Class<Resource> clazz2 = null;
        int n = classArray.length;
        while (--n >= 0 && !FeatureSet.class.isAssignableFrom(clazz2 = classArray[n])) {
        }
        return clazz2;
    }

    public static String[] getFileSuffixes(Class<? extends DataStoreProvider> clazz) {
        StoreMetadata storeMetadata;
        if (clazz != null && (storeMetadata = clazz.getAnnotation(StoreMetadata.class)) != null) {
            return storeMetadata.fileSuffixes();
        }
        return CharSequences.EMPTY_ARRAY;
    }

    public static Boolean canWrite(Class<? extends DataStoreProvider> clazz) {
        StoreMetadata storeMetadata;
        if (clazz != null && (storeMetadata = clazz.getAnnotation(StoreMetadata.class)) != null) {
            for (Capability capability : storeMetadata.capabilities()) {
                if (!Capability.WRITE.equals((Object)capability)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static EnumSet<StandardOpenOption> toStandardOptions(OpenOption[] openOptionArray) {
        EnumSet<StandardOpenOption> enumSet = EnumSet.noneOf(StandardOpenOption.class);
        if (openOptionArray != null) {
            for (OpenOption openOption : openOptionArray) {
                if (!(openOption instanceof StandardOpenOption)) continue;
                switch ((StandardOpenOption)openOption) {
                    case CREATE_NEW: {
                        enumSet.add(StandardOpenOption.CREATE_NEW);
                    }
                    case TRUNCATE_EXISTING: {
                        enumSet.add(StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    case CREATE: {
                        enumSet.add(StandardOpenOption.CREATE);
                    }
                    case APPEND: 
                    case WRITE: {
                        enumSet.add(StandardOpenOption.WRITE);
                    }
                }
            }
            if (enumSet.contains(StandardOpenOption.CREATE_NEW)) {
                enumSet.remove(StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        return enumSet;
    }

    public static boolean basedOnASCII(Charset charset) {
        return basedOnASCII.contains(charset.name());
    }

    public static DataStoreProvider providerByFormatName(String string) throws UnsupportedStorageException {
        for (DataStoreProvider dataStoreProvider : DataStores.providers()) {
            if (!string.equalsIgnoreCase(StoreUtilities.getFormatName(dataStoreProvider))) continue;
            return dataStoreProvider;
        }
        throw new UnsupportedStorageException(Errors.format((short)181, string));
    }

    public static void copy(FeatureSet featureSet, WritableFeatureSet writableFeatureSet) throws DataStoreException {
        writableFeatureSet.updateType(featureSet.getType());
        try (Stream<AbstractFeature> stream = featureSet.features(false);){
            writableFeatureSet.add(stream.iterator());
        }
    }

    public static String resourceNotFound(DataStore dataStore, String string) {
        return Resources.forLocale(dataStore.getLocale()).getString((short)24, dataStore.getDisplayName(), string);
    }

    public static Filter removeStackTraceInLogs() {
        return logRecord -> {
            logRecord.setThrown(null);
            return true;
        };
    }
}

