/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET_NOTIFICATION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/buckets/{bucket}/notificationConfigs/{notification_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;
    private final String notificationConfig;

    @Deprecated
    protected NotificationConfigName() {
        this.project = null;
        this.bucket = null;
        this.notificationConfig = null;
    }

    private NotificationConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getNotificationConfig() {
        return this.notificationConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationConfigName of(String project, String bucket, String notificationConfig) {
        return NotificationConfigName.newBuilder().setProject(project).setBucket(bucket).setNotificationConfig(notificationConfig).build();
    }

    public static String format(String project, String bucket, String notificationConfig) {
        return NotificationConfigName.newBuilder().setProject(project).setBucket(bucket).setNotificationConfig(notificationConfig).build().toString();
    }

    public static NotificationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_BUCKET_NOTIFICATION_CONFIG.validatedMatch(formattedString, "NotificationConfigName.parse: formattedString not in valid format");
        return NotificationConfigName.of((String)matchMap.get("project"), (String)matchMap.get("bucket"), (String)matchMap.get("notification_config"));
    }

    public static List<NotificationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationConfigName> list = new ArrayList<NotificationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET_NOTIFICATION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationConfigName notificationConfigName = this;
            synchronized (notificationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put((Object)"bucket", (Object)this.bucket);
                    }
                    if (this.notificationConfig != null) {
                        fieldMapBuilder.put((Object)"notification_config", (Object)this.notificationConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET_NOTIFICATION_CONFIG.instantiate(new String[]{"project", this.project, "bucket", this.bucket, "notification_config", this.notificationConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationConfigName that = (NotificationConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.notificationConfig, that.notificationConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notificationConfig);
    }

    public static class Builder {
        private String project;
        private String bucket;
        private String notificationConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        private Builder(NotificationConfigName notificationConfigName) {
            this.project = notificationConfigName.project;
            this.bucket = notificationConfigName.bucket;
            this.notificationConfig = notificationConfigName.notificationConfig;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }
}

