/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

public class HorizontalBox
extends Box {
    private float curPos = 0.0f;
    protected List<Integer> breakPositions;

    public HorizontalBox(Box b, float w, int alignment) {
        if (w != Float.POSITIVE_INFINITY) {
            float rest = w - b.getWidth();
            if (rest > 0.0f) {
                if (alignment == 2 || alignment == 5) {
                    StrutBox s = new StrutBox(rest / 2.0f, 0.0f, 0.0f, 0.0f);
                    this.add(s);
                    this.add(b);
                    this.add(s);
                } else if (alignment == 0) {
                    this.add(b);
                    this.add(new StrutBox(rest, 0.0f, 0.0f, 0.0f));
                } else if (alignment == 1) {
                    this.add(new StrutBox(rest, 0.0f, 0.0f, 0.0f));
                    this.add(b);
                } else {
                    this.add(b);
                }
            } else {
                this.add(b);
            }
        } else {
            this.add(b);
        }
    }

    public HorizontalBox(Box b) {
        this.add(b);
    }

    public HorizontalBox() {
    }

    public HorizontalBox(Color fg, Color bg) {
        super(fg, bg);
    }

    public HorizontalBox cloneBox() {
        HorizontalBox b = new HorizontalBox(this.foreground, this.background);
        b.shift = this.shift;
        return b;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.startDraw(g2, x, y);
        float xPos = x;
        for (Box box : this.children) {
            box.draw(g2, xPos, y + box.shift);
            xPos += box.getWidth();
        }
        this.endDraw(g2);
    }

    @Override
    public final void add(Box b) {
        this.recalculate(b);
        super.add(b);
    }

    @Override
    public final void add(int pos, Box b) {
        this.recalculate(b);
        super.add(pos, b);
    }

    private void recalculate(Box b) {
        this.width += b.getWidth();
        this.height = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.height, b.height - b.shift);
        this.depth = Math.max(this.children.size() == 0 ? Float.NEGATIVE_INFINITY : this.depth, b.depth + b.shift);
    }

    @Override
    public int getLastFontId() {
        int fontId = -1;
        ListIterator it = this.children.listIterator(this.children.size());
        while (fontId == -1 && it.hasPrevious()) {
            fontId = ((Box)it.previous()).getLastFontId();
        }
        return fontId;
    }

    public void addBreakPosition(int pos) {
        if (this.breakPositions == null) {
            this.breakPositions = new ArrayList<Integer>();
        }
        this.breakPositions.add(pos);
    }

    protected HorizontalBox[] split(int position) {
        return this.split(position, 1);
    }

    protected HorizontalBox[] splitRemove(int position) {
        return this.split(position, 2);
    }

    private HorizontalBox[] split(int position, int shift) {
        int i;
        HorizontalBox hb1 = this.cloneBox();
        HorizontalBox hb2 = this.cloneBox();
        for (i = 0; i <= position; ++i) {
            hb1.add((Box)this.children.get(i));
        }
        for (i = position + shift; i < this.children.size(); ++i) {
            hb2.add((Box)this.children.get(i));
        }
        if (this.breakPositions != null) {
            for (i = 0; i < this.breakPositions.size(); ++i) {
                if (this.breakPositions.get(i) <= position + 1) continue;
                hb2.addBreakPosition(this.breakPositions.get(i) - position - 1);
            }
        }
        return new HorizontalBox[]{hb1, hb2};
    }
}

