/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import shaded.com.google.common.collect.ImmutableList;

public class Rename
extends UnresolvedPlan {
    private final List<Map> renameList;
    private UnresolvedPlan child;

    public Rename(List<Map> renameList, UnresolvedPlan child) {
        this.renameList = renameList;
        this.child = child;
        this.validate();
    }

    public Rename(List<Map> renameList) {
        this.renameList = renameList;
        this.validate();
    }

    private void validate() {
        this.renameList.forEach(rename -> this.validate(rename.getTarget()));
    }

    private void validate(UnresolvedExpression expr) {
        Field field;
        String name;
        if (expr instanceof Field && OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(name = (field = (Field)expr).getField().toString())) {
            throw new IllegalArgumentException(String.format("Cannot use metadata field [%s] in Rename command.", name));
        }
    }

    @Override
    public Rename attach(UnresolvedPlan child) {
        if (null == this.child) {
            this.child = child;
        } else {
            this.child.attach(child);
        }
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitRename(this, context);
    }

    @Override
    @Generated
    public String toString() {
        return "Rename(renameList=" + String.valueOf(this.getRenameList()) + ", child=" + String.valueOf(this.getChild()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rename)) {
            return false;
        }
        Rename other = (Rename)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Map> this$renameList = this.getRenameList();
        List<Map> other$renameList = other.getRenameList();
        if (this$renameList == null ? other$renameList != null : !((Object)this$renameList).equals(other$renameList)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rename;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Map> $renameList = this.getRenameList();
        result = result * 59 + ($renameList == null ? 43 : ((Object)$renameList).hashCode());
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }

    @Generated
    public List<Map> getRenameList() {
        return this.renameList;
    }
}

