/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.BitsProducer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.CompletionWeight;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;

public class RegexCompletionQuery
extends CompletionQuery {
    private final int flags;
    private final int determinizeWorkLimit;

    public RegexCompletionQuery(Term term) {
        this(term, null);
    }

    public RegexCompletionQuery(Term term, BitsProducer filter) {
        this(term, 255, 10000, filter);
    }

    public RegexCompletionQuery(Term term, int flags, int determinizeWorkLimit) {
        this(term, flags, determinizeWorkLimit, null);
    }

    public RegexCompletionQuery(Term term, int flags, int determinizeWorkLimit, BitsProducer filter) {
        super(term, filter);
        this.flags = flags;
        this.determinizeWorkLimit = determinizeWorkLimit;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Automaton automaton = this.getTerm().text().isEmpty() ? Automata.makeEmpty() : Operations.determinize((Automaton)new RegExp(this.getTerm().text(), this.flags).toAutomaton(), (int)this.determinizeWorkLimit);
        return new CompletionWeight(this, automaton);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDeterminizeWorkLimit() {
        return this.determinizeWorkLimit;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }
}

