#!/bin/bash

# SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved. 
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction, 
# disclosure or distribution of this material and related documentation 
# without an express license agreement from NVIDIA CORPORATION or 
# its affiliates is strictly prohibited.

script_dir=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)

if [ "$(command -v dnf)" ]; then
    package_manager=dnf
elif [ "$(command -v yum)" ]; then
    package_manager=yum
else
    echo "Only dnf and yum package managers are supported.";
    exit 1;
fi;

# shellcheck disable=SC2046
$package_manager install -y $(cat "$script_dir/packages.list")
