/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.Array;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionIdJavaClass;
import org.hibernate.annotations.CollectionIdJavaType;
import org.hibernate.annotations.CollectionIdJdbcType;
import org.hibernate.annotations.CollectionIdJdbcTypeCode;
import org.hibernate.annotations.CollectionIdMutability;
import org.hibernate.annotations.CollectionIdType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ListIndexJavaType;
import org.hibernate.annotations.ListIndexJdbcType;
import org.hibernate.annotations.ListIndexJdbcTypeCode;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyMutability;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.PartitionKey;
import org.hibernate.annotations.Struct;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.annotations.Type;
import org.hibernate.boot.internal.AnyKeyType;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.SetBasicValueTypeSecondPass;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.Immutability;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.ParameterizedTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;

public class BasicValueBinder
implements JdbcTypeIndicators {
    private final Kind kind;
    private final Component aggregateComponent;
    private final MetadataBuildingContext buildingContext;
    private Class<? extends UserType<?>> explicitCustomType;
    private Map<String, String> explicitLocalTypeParams;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, BasicJavaType<?>> explicitJavaTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private MemberDetails memberDetails;
    private AccessType accessType;
    private ConverterDescriptor<?, ?> converterDescriptor;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumType;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private boolean partitionKey;
    private Integer jdbcTypeCode;
    private Table table;
    private AnnotatedColumns columns;
    private BasicValue basicValue;
    private String persistentClassName;
    private String returnedClassName;
    private String referencedEntityName;

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        this(kind, null, buildingContext);
    }

    public BasicValueBinder(Kind kind, Component aggregateComponent, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.aggregateComponent = aggregateComponent;
        this.buildingContext = buildingContext;
    }

    protected ModelsContext getSourceModelContext() {
        return this.buildingContext.getBootstrapContext().getModelsContext();
    }

    private InFlightMetadataCollector getMetadataCollector() {
        return this.buildingContext.getMetadataCollector();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return BasicValue.timeZoneStorageStrategy(this.timeZoneStorageType, this.buildingContext);
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        JdbcType type;
        if (this.isLob) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null && (type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration())) != null) {
            return type.isLob();
        }
        return false;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return this.buildingContext.isPreferJavaTimeJdbcTypesEnabled();
    }

    @Override
    public boolean isPreferNativeEnumTypesEnabled() {
        return this.buildingContext.isPreferNativeEnumTypesEnabled();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForDuration());
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForUuid());
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForInstant());
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForArray());
    }

    @Override
    public int resolveJdbcTypeCode(int jdbcTypeCode) {
        return this.aggregateComponent == null ? jdbcTypeCode : this.getAggregateSupport().aggregateComponentSqlTypeCode(this.aggregateComponent.getAggregateColumn().getSqlTypeCode(), jdbcTypeCode);
    }

    private AggregateSupport getAggregateSupport() {
        return this.getMetadataCollector().getDatabase().getDialect().getAggregateSupport();
    }

    @Override
    public boolean isNationalized() {
        if (this.isNationalized) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null) {
            JdbcType type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration());
            return type != null && type.isNationalized();
        }
        return false;
    }

    public void setVersion(boolean isVersion) {
        if (isVersion && this.basicValue != null) {
            this.basicValue.makeVersion();
        }
    }

    void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    private static JdbcType getDescriptor(TypeConfiguration typeConfiguration, int code) {
        return typeConfiguration.getJdbcTypeRegistry().getDescriptor(code);
    }

    public void setType(MemberDetails value, TypeDetails typeDetails, String declaringClassName, @Nullable ConverterDescriptor converterDescriptor) {
        TypeDetails modelClassDetails;
        this.memberDetails = value;
        boolean isArray = value.isArray();
        if (typeDetails == null && !isArray) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("`BasicValueBinder#setColumns` should be called before `BasicValueBinder#setType`");
        }
        TypeDetails typeDetails2 = modelClassDetails = isArray ? value.getElementType() : typeDetails;
        if (this.kind != Kind.LIST_INDEX && this.kind != Kind.MAP_KEY) {
            this.isLob = value.hasDirectAnnotationUsage(Lob.class);
        }
        if (this.getDialect().getNationalizationSupport() == NationalizationSupport.EXPLICIT) {
            boolean bl = this.isNationalized = this.buildingContext.getBuildingOptions().useNationalizedCharacterData() || value.locateAnnotationUsage(Nationalized.class, this.getSourceModelContext()) != null;
        }
        if (converterDescriptor != null) {
            this.applyJpaConverter(value, converterDescriptor);
        } else {
            Class<? extends UserType<?>> userTypeImpl = this.kind.mappingAccess.customType(value, this.getSourceModelContext());
            if (userTypeImpl != null) {
                this.applyExplicitType(userTypeImpl, this.kind.mappingAccess.customTypeParameters(value, this.getSourceModelContext()));
                return;
            }
            if (modelClassDetails != null) {
                ClassDetails rawClassDetails = modelClassDetails.determineRawClass();
                Class basicClass = rawClassDetails.toJavaClass();
                Class<? extends UserType<?>> registeredUserTypeImpl = this.getMetadataCollector().findRegisteredUserType(basicClass);
                if (registeredUserTypeImpl != null) {
                    this.applyExplicitType(registeredUserTypeImpl, Collections.emptyMap());
                    return;
                }
            }
        }
        switch (this.kind.ordinal()) {
            case 0: {
                this.prepareBasicAttribute(declaringClassName, value, typeDetails);
                break;
            }
            case 1: {
                this.prepareAnyDiscriminator(value);
                break;
            }
            case 2: {
                this.prepareAnyKey(value);
                break;
            }
            case 5: {
                this.prepareCollectionId(value);
                break;
            }
            case 6: {
                this.prepareListIndex(value);
                break;
            }
            case 3: {
                this.prepareMapKey(value, typeDetails);
                break;
            }
            case 4: {
                this.prepareCollectionElement(value, typeDetails);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binder type : " + String.valueOf((Object)this.kind));
            }
        }
    }

    private void applyExplicitType(Class<? extends UserType<?>> impl, Map<String, String> params) {
        this.explicitCustomType = impl;
        this.explicitLocalTypeParams = params;
    }

    private void prepareCollectionId(MemberDetails attribute) {
        CollectionId collectionIdAnn = (CollectionId)attribute.getDirectAnnotationUsage(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        boolean useDeferredBeanContainerAccess = this.useDeferredBeanContainerAccess();
        ManagedBeanRegistry beanRegistry = this.getManagedBeanRegistry();
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            CollectionIdJavaClass javaClassAnn = (CollectionIdJavaClass)attribute.locateAnnotationUsage(CollectionIdJavaClass.class, this.getSourceModelContext());
            if (javaClassAnn != null) {
                return (BasicJavaType)this.buildingContext.getBootstrapContext().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaClassAnn.idType());
            }
            CollectionIdJavaType javaTypeAnn = (CollectionIdJavaType)attribute.locateAnnotationUsage(CollectionIdJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return beanRegistry.getBean(javaTypeClass).getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int code;
            Class<? extends JdbcType> jdbcTypeClass;
            CollectionIdJdbcType jdbcTypeAnn = (CollectionIdJdbcType)attribute.locateAnnotationUsage(CollectionIdJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return beanRegistry.getBean(jdbcTypeClass).getBeanInstance();
            }
            CollectionIdJdbcTypeCode jdbcTypeCodeAnn = (CollectionIdJdbcTypeCode)attribute.locateAnnotationUsage(CollectionIdJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (code = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return BasicValueBinder.getDescriptor(typeConfiguration, code);
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class<java.lang.reflect.Type> attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            CollectionIdMutability mutabilityAnn = (CollectionIdMutability)attribute.locateAnnotationUsage(CollectionIdMutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attribute, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private boolean useDeferredBeanContainerAccess() {
        return !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
    }

    private ManagedBeanRegistry getManagedBeanRegistry() {
        return this.buildingContext.getBootstrapContext().getManagedBeanRegistry();
    }

    private void prepareMapKey(MemberDetails attribute, TypeDetails explicitMapKeyTypeDetails) {
        MapKeyTemporal mapKeyTemporalAnn;
        TypeDetails mapKeyClass = explicitMapKeyTypeDetails == null ? attribute.getMapKeyType() : explicitMapKeyTypeDetails;
        this.implicitJavaTypeAccess = typeConfiguration -> {
            ClassDetails rawKeyClassDetails = mapKeyClass.determineRawClass();
            return rawKeyClassDetails.toJavaClass();
        };
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)attribute.getDirectAnnotationUsage(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)attribute.getDirectAnnotationUsage(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
        boolean useDeferredBeanContainerAccess = this.useDeferredBeanContainerAccess();
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            MapKeyJdbcType jdbcTypeAnn = (MapKeyJdbcType)attribute.locateAnnotationUsage(MapKeyJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            MapKeyJdbcTypeCode jdbcTypeCodeAnn = (MapKeyJdbcTypeCode)attribute.locateAnnotationUsage(MapKeyJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return BasicValueBinder.getDescriptor(typeConfiguration, jdbcTypeCode);
            }
            return null;
        };
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            MapKeyJavaType javaTypeAnn = (MapKeyJavaType)attribute.locateAnnotationUsage(MapKeyJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            MapKeyClass mapKeyClassAnn = (MapKeyClass)attribute.getDirectAnnotationUsage(MapKeyClass.class);
            if (mapKeyClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(mapKeyClassAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class<java.lang.reflect.Type> attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            MapKeyMutability mutabilityAnn = (MapKeyMutability)attribute.locateAnnotationUsage(MapKeyMutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.MAP_KEY.mappingAccess.customType(attribute, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private void prepareListIndex(MemberDetails attribute) {
        this.implicitJavaTypeAccess = typeConfiguration -> Integer.class;
        boolean useDeferredBeanContainerAccess = this.useDeferredBeanContainerAccess();
        ManagedBeanRegistry beanRegistry = this.getManagedBeanRegistry();
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            ListIndexJavaType javaTypeAnn = (ListIndexJavaType)attribute.locateAnnotationUsage(ListIndexJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return beanRegistry.getBean(javaTypeClass).getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<? extends JdbcType> jdbcTypeClass;
            ListIndexJdbcType jdbcTypeAnn = (ListIndexJdbcType)attribute.locateAnnotationUsage(ListIndexJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return beanRegistry.getBean(jdbcTypeClass).getBeanInstance();
            }
            ListIndexJdbcTypeCode jdbcTypeCodeAnn = (ListIndexJdbcTypeCode)attribute.locateAnnotationUsage(ListIndexJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null) {
                return BasicValueBinder.getDescriptor(typeConfiguration, jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void prepareCollectionElement(MemberDetails attribute, TypeDetails explicitElementTypeDetails) {
        Class targetClassDetails;
        TypeDetails elementTypeDetails = explicitElementTypeDetails == null && attribute.isArray() ? attribute.getElementType() : explicitElementTypeDetails;
        ClassDetails rawElementType = elementTypeDetails.determineRawClass();
        Class javaType = rawElementType.toJavaClass();
        Class<Class> javaTypeClass = ReflectHelper.getClass(javaType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attribute.getDirectAnnotationUsage(Temporal.class);
        if (temporalAnn != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedAnnotation(Temporal.class, attribute.getName());
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attribute.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaTypeClass.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attribute.getDirectAnnotationUsage(Enumerated.class);
            if (enumeratedAnn != null) {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attribute.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attribute);
        ElementCollection elementCollectionAnn = (ElementCollection)attribute.getDirectAnnotationUsage(ElementCollection.class);
        if (elementCollectionAnn != null && (targetClassDetails = elementCollectionAnn.targetClass()) != Void.TYPE) {
            Function<TypeConfiguration, BasicJavaType<?>> original = this.explicitJavaTypeAccess;
            this.explicitJavaTypeAccess = typeConfiguration -> {
                BasicJavaType originalResult = (BasicJavaType)original.apply((TypeConfiguration)typeConfiguration);
                if (originalResult != null) {
                    return originalResult;
                }
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(targetClassDetails);
            };
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareBasicAttribute(String declaringClassName, MemberDetails attribute, TypeDetails attributeType) {
        Enumerated enumeratedAnn;
        Class javaTypeClass = attributeType.determineRawClass().toJavaClass();
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (attributeType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
                return ParameterizedTypeImpl.from(attributeType.asParameterizedType());
            }
            return attributeType.determineRawClass().toJavaClass();
        };
        Temporal temporalAnn = (Temporal)attribute.getDirectAnnotationUsage(Temporal.class);
        if (temporalAnn != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedAnnotation(Temporal.class, declaringClassName + "." + attribute.getName());
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + declaringClassName + "." + attribute.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if ((enumeratedAnn = (Enumerated)attribute.getDirectAnnotationUsage(Enumerated.class)) != null) {
            this.enumType = enumeratedAnn.value();
            if (!this.canUseEnumerated(attributeType, javaTypeClass)) throw new AnnotationException(String.format("Property '%s.%s' is annotated '@Enumerated' but its type '%s' is not an enum", declaringClassName, attribute.getName(), attributeType.getName()));
            if (this.enumType == null) {
                throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + declaringClassName + "." + attribute.getName());
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attribute);
    }

    private boolean canUseEnumerated(TypeDetails javaType, Class<?> javaTypeClass) {
        if (javaTypeClass.isEnum() || javaTypeClass.isArray() && javaTypeClass.getComponentType().isEnum()) {
            return true;
        }
        if (javaType.isImplementor(Collection.class)) {
            List typeArguments = javaType.asParameterizedType().getArguments();
            return !typeArguments.isEmpty() && ((TypeDetails)typeArguments.get(0)).isImplementor(Enum.class);
        }
        return false;
    }

    private void prepareAnyDiscriminator(MemberDetails memberDetails) {
        AnyDiscriminator anyDiscriminatorAnn = (AnyDiscriminator)memberDetails.locateAnnotationUsage(AnyDiscriminator.class, this.getSourceModelContext());
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (anyDiscriminatorAnn != null) {
                return switch (anyDiscriminatorAnn.value()) {
                    case DiscriminatorType.CHAR -> Character.class;
                    case DiscriminatorType.INTEGER -> Integer.class;
                    default -> String.class;
                };
            }
            return String.class;
        };
        this.normalJdbcTypeDetails(memberDetails);
        this.normalMutabilityDetails(memberDetails);
        Function<TypeConfiguration, JdbcType> originalJdbcTypeResolution = this.explicitJdbcTypeAccess;
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            JdbcType originalResolution = (JdbcType)originalJdbcTypeResolution.apply((TypeConfiguration)typeConfiguration);
            if (originalResolution != null) {
                return originalResolution;
            }
            Class hintedJavaType = (Class)this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
            JavaType hintedDescriptor = typeConfiguration.getJavaTypeRegistry().getDescriptor(hintedJavaType);
            return hintedDescriptor.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        };
    }

    private void prepareAnyKey(MemberDetails member) {
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        boolean useDeferredBeanContainerAccess = this.useDeferredBeanContainerAccess();
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> implClass;
            AnyKeyJavaType javaTypeAnn = (AnyKeyJavaType)member.locateAnnotationUsage(AnyKeyJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (implClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(implClass);
                }
                return this.getManagedBeanRegistry().getBean(implClass).getBeanInstance();
            }
            AnyKeyJavaClass javaClassAnn = (AnyKeyJavaClass)member.locateAnnotationUsage(AnyKeyJavaClass.class, this.getSourceModelContext());
            if (javaClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(javaClassAnn.value());
            }
            AnyKeyType anyKeyTypeAnn = (AnyKeyType)member.locateAnnotationUsage(AnyKeyType.class, this.getSourceModelContext());
            if (anyKeyTypeAnn != null) {
                String namedType = anyKeyTypeAnn.value();
                BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(namedType);
                if (registeredType == null) {
                    throw new MappingException("Unrecognized @AnyKeyType value - " + namedType);
                }
                return (BasicJavaType)registeredType.getJavaTypeDescriptor();
            }
            throw new MappingException("Could not determine key type for '@Any' mapping (specify '@AnyKeyJavaType' or '@AnyKeyJavaClass')");
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int code;
            Class<? extends JdbcType> jdbcTypeClass;
            AnyKeyJdbcType jdbcTypeAnn = (AnyKeyJdbcType)member.locateAnnotationUsage(AnyKeyJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            AnyKeyJdbcTypeCode jdbcTypeCodeAnn = (AnyKeyJdbcTypeCode)member.locateAnnotationUsage(AnyKeyJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (code = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return BasicValueBinder.getDescriptor(typeConfiguration, code);
            }
            return null;
        };
    }

    private void normalJdbcTypeDetails(MemberDetails attribute) {
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            org.hibernate.annotations.JdbcType jdbcTypeAnn = (org.hibernate.annotations.JdbcType)attribute.locateAnnotationUsage(org.hibernate.annotations.JdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (this.useDeferredBeanContainerAccess()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            JdbcTypeCode jdbcTypeCodeAnn = (JdbcTypeCode)attribute.locateAnnotationUsage(JdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
                if (jdbcTypeRegistry.getConstructor(jdbcTypeCode) != null) {
                    return null;
                }
                return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
            }
            return null;
        };
    }

    private void normalMutabilityDetails(MemberDetails attribute) {
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class<? extends MutabilityPlan<?>> mutability;
            Mutability mutabilityAnn = (Mutability)attribute.locateAnnotationUsage(Mutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutability = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutability);
            }
            if (attribute.hasDirectAnnotationUsage(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.explicitJavaTypeAccess != null || this.implicitJavaTypeAccess != null) {
                java.lang.reflect.Type javaType;
                BasicJavaType<?> jtd;
                Class<Object> attributeType = null;
                if (this.explicitJavaTypeAccess != null && (jtd = this.explicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = jtd.getJavaTypeClass();
                }
                if (attributeType == null && (javaType = this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = ReflectHelper.getClass(javaType);
                }
                if (attributeType != null) {
                    Class<? extends MutabilityPlan<?>> mutability2;
                    Mutability classMutability = attributeType.getAnnotation(Mutability.class);
                    if (classMutability != null && (mutability2 = classMutability.value()) != null) {
                        return this.resolveMutability(mutability2);
                    }
                    Immutable classImmutable = attributeType.getAnnotation(Immutable.class);
                    if (classImmutable != null) {
                        return ImmutableMutabilityPlan.instance();
                    }
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                Immutable converterImmutableAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Immutable.class);
                if (converterImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attribute, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                Immutable customTypeImmutableAnn = customTypeImpl.getAnnotation(Immutable.class);
                if (customTypeImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private <T> MutabilityPlan<T> resolveMutability(Class<? extends MutabilityPlan> mutability) {
        if (mutability.equals(Immutability.class)) {
            return Immutability.instance();
        }
        if (mutability.equals(ImmutableMutabilityPlan.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (this.useDeferredBeanContainerAccess()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(mutability);
        }
        return this.getManagedBeanRegistry().getBean(mutability).getBeanInstance();
    }

    private void normalSupplementalDetails(MemberDetails attribute) {
        TimeZoneStorage timeZoneStorage;
        Temporal temporal;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            org.hibernate.annotations.JavaType javaType = (org.hibernate.annotations.JavaType)attribute.locateAnnotationUsage(org.hibernate.annotations.JavaType.class, this.getSourceModelContext());
            if (javaType != null && (javaTypeClass = javaType.value()) != null) {
                if (this.useDeferredBeanContainerAccess()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            return null;
        };
        JdbcTypeCode jdbcType = (JdbcTypeCode)attribute.locateAnnotationUsage(JdbcTypeCode.class, this.getSourceModelContext());
        if (jdbcType != null) {
            this.jdbcTypeCode = jdbcType.value();
        }
        this.normalJdbcTypeDetails(attribute);
        this.normalMutabilityDetails(attribute);
        Enumerated enumerated = (Enumerated)attribute.getDirectAnnotationUsage(Enumerated.class);
        if (enumerated != null) {
            this.enumType = enumerated.value();
        }
        if ((temporal = (Temporal)attribute.getDirectAnnotationUsage(Temporal.class)) != null) {
            this.temporalPrecision = temporal.value();
        }
        if ((timeZoneStorage = (TimeZoneStorage)attribute.getDirectAnnotationUsage(TimeZoneStorage.class)) != null) {
            this.timeZoneStorageType = timeZoneStorage.value();
            TimeZoneColumn timeZoneColumnAnn = (TimeZoneColumn)attribute.getDirectAnnotationUsage(TimeZoneColumn.class);
            if (timeZoneColumnAnn != null && this.timeZoneStorageType != TimeZoneStorageType.AUTO && this.timeZoneStorageType != TimeZoneStorageType.COLUMN) {
                throw new IllegalStateException("'@TimeZoneColumn' can not be used in conjunction with '@TimeZoneStorage( " + String.valueOf((Object)this.timeZoneStorageType) + " )' for attribute '" + attribute.getDeclaringType().getName() + "." + attribute.getName() + "'");
            }
        }
        this.partitionKey = attribute.hasDirectAnnotationUsage(PartitionKey.class);
    }

    @Override
    public Dialect getDialect() {
        return this.getMetadataCollector().getDatabase().getDialect();
    }

    private void applyJpaConverter(MemberDetails attribute, ConverterDescriptor<?, ?> attributeConverterDescriptor) {
        boolean autoApply = attributeConverterDescriptor.getAutoApplyDescriptor().isAutoApplicable();
        this.disallowConverter(attribute, Id.class, autoApply);
        this.disallowConverter(attribute, Version.class, autoApply);
        if (this.kind == Kind.MAP_KEY) {
            this.disallowConverter(attribute, MapKeyTemporal.class, autoApply);
            this.disallowConverter(attribute, MapKeyEnumerated.class, autoApply);
        } else {
            this.disallowConverter(attribute, Temporal.class, autoApply);
            this.disallowConverter(attribute, Enumerated.class, autoApply);
            this.disallowConverter(attribute, ManyToOne.class, autoApply);
            this.disallowConverter(attribute, OneToOne.class, autoApply);
            this.disallowConverter(attribute, OneToMany.class, autoApply);
            this.disallowConverter(attribute, ManyToMany.class, autoApply);
            this.disallowConverter(attribute, Embedded.class, autoApply);
            this.disallowConverter(attribute, EmbeddedId.class, autoApply);
        }
        this.disallowConverter(attribute, Struct.class, autoApply);
        this.disallowConverter(attribute, Array.class, autoApply);
        this.disallowConverter(attribute, Any.class, autoApply);
        this.converterDescriptor = attributeConverterDescriptor;
    }

    void disallowConverter(MemberDetails attribute, Class<? extends Annotation> annotationType, boolean autoApply) {
        if (attribute.hasDirectAnnotationUsage(annotationType)) {
            throw new AnnotationException("'AttributeConverter' not allowed for attribute '" + attribute.getName() + "' annotated '@" + annotationType.getName() + "'" + (autoApply ? " (use '@Convert(disableConversion=true)' to suppress this error)" : ""));
        }
    }

    public BasicValue make() {
        if (this.basicValue != null) {
            return this.basicValue;
        }
        this.columns.checkPropertyConsistency();
        if (this.table == null) {
            this.table = this.columns.getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.columns.getPropertyHolder().isComponent()) {
            ComponentPropertyHolder propertyHolder = (ComponentPropertyHolder)this.columns.getPropertyHolder();
            this.basicValue.setAggregateColumn(propertyHolder.getAggregateColumn());
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        this.basicValue.setPartitionKey(this.partitionKey);
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.jdbcTypeCode != null) {
            this.basicValue.setExplicitJdbcTypeCode(this.jdbcTypeCode);
        }
        this.linkWithValue();
        if (!this.getMetadataCollector().isInSecondPass()) {
            this.getMetadataCollector().addSecondPass(new SetBasicValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    private void linkWithValue() {
        InFlightMetadataCollector collector = this.getMetadataCollector();
        AnnotatedColumn firstColumn = this.columns.getColumns().get(0);
        if (!collector.isInSecondPass() && firstColumn.isNameDeferred() && this.referencedEntityName != null) {
            collector.addSecondPass(new OverriddenFkSecondPass(this.basicValue, this.referencedEntityName, this.columns));
        } else if (this.aggregateComponent != null) {
            assert (this.columns.getColumns().size() == 1);
            firstColumn.linkWithAggregateValue(this.basicValue, this.aggregateComponent);
        } else {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        if (this.explicitCustomType != null && DynamicParameterizedType.class.isAssignableFrom(this.explicitCustomType)) {
            this.basicValue.setTypeParameters(this.createDynamicParameterizedTypeParameters());
        }
        if (this.converterDescriptor != null) {
            this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        }
        if (this.implicitJavaTypeAccess != null) {
            this.basicValue.setImplicitJavaTypeAccess(this.implicitJavaTypeAccess);
        }
        if (this.explicitJavaTypeAccess != null) {
            this.basicValue.setExplicitJavaTypeAccess(this.explicitJavaTypeAccess);
        }
        if (this.explicitJdbcTypeAccess != null) {
            this.basicValue.setExplicitJdbcTypeAccess(this.explicitJdbcTypeAccess);
        }
        if (this.explicitMutabilityAccess != null) {
            this.basicValue.setExplicitMutabilityPlanAccess(this.explicitMutabilityAccess);
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.explicitCustomType != null) {
            this.basicValue.setExplicitCustomType(this.explicitCustomType);
        }
    }

    private Map<String, Object> createDynamicParameterizedTypeParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.returnedClassName == null) {
            throw new MappingException("Returned class name not specified for basic mapping: " + this.memberDetails.getName());
        }
        parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        parameters.put("org.hibernate.type.ParameterType.xproperty", this.memberDetails);
        parameters.put("org.hibernate.type.ParameterType.propertyName", this.memberDetails.getName());
        parameters.put("org.hibernate.type.ParameterType.dynamic", Boolean.toString(true));
        parameters.put("org.hibernate.type.ParameterType.primaryKey", Boolean.toString(this.kind == Kind.MAP_KEY));
        if (this.persistentClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.entityClass", this.persistentClassName);
        }
        if (this.returnedClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        }
        if (this.accessType != null) {
            parameters.put("org.hibernate.type.ParameterType.accessType", this.accessType.getType());
        }
        if (this.explicitLocalTypeParams != null) {
            parameters.putAll(this.explicitLocalTypeParams);
        }
        return parameters;
    }

    private static AnnotatedJoinColumns convertToJoinColumns(AnnotatedColumns columns, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        joinColumns.setPropertyHolder(columns.getPropertyHolder());
        joinColumns.setPropertyName(columns.getPropertyName());
        for (AnnotatedColumn column : columns.getColumns()) {
            column.setParent(joinColumns);
        }
        return joinColumns;
    }

    public static enum Kind {
        ATTRIBUTE(ValueMappingAccess.INSTANCE),
        ANY_DISCRIMINATOR(AnyDiscriminatorMappingAccess.INSTANCE),
        ANY_KEY(AnyKeyMappingAccess.INSTANCE),
        MAP_KEY(MapKeyMappingAccess.INSTANCE),
        COLLECTION_ELEMENT(ValueMappingAccess.INSTANCE),
        COLLECTION_ID(CollectionIdMappingAccess.INSTANCE),
        LIST_INDEX(ListIndexMappingAccess.INSTANCE);

        private final BasicMappingAccess mappingAccess;

        private Kind(BasicMappingAccess mappingAccess) {
            this.mappingAccess = mappingAccess;
        }
    }

    private static interface BasicMappingAccess {
        public Class<? extends UserType<?>> customType(MemberDetails var1, ModelsContext var2);

        public Map<String, String> customTypeParameters(MemberDetails var1, ModelsContext var2);
    }

    private static class OverriddenFkSecondPass
    implements FkSecondPass {
        private final AnnotatedJoinColumns joinColumns;
        private final BasicValue value;
        private final String referencedEntityName;

        public OverriddenFkSecondPass(BasicValue value, String referencedEntityName, AnnotatedColumns columns) {
            this.value = value;
            this.referencedEntityName = referencedEntityName;
            this.joinColumns = BasicValueBinder.convertToJoinColumns(columns, value.getBuildingContext());
        }

        @Override
        public BasicValue getValue() {
            return this.value;
        }

        @Override
        public String getReferencedEntityName() {
            return this.referencedEntityName;
        }

        @Override
        public boolean isInPrimaryKey() {
            return true;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
            PersistentClass referencedEntity = persistentClasses.get(this.referencedEntityName);
            if (referencedEntity == null) {
                throw new AnnotationException("Unknown entity name '" + this.referencedEntityName + "'");
            }
            TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, referencedEntity.getKey(), this.joinColumns, this.value);
        }
    }

    private static class ListIndexMappingAccess
    implements BasicMappingAccess {
        private static final ListIndexMappingAccess INSTANCE = new ListIndexMappingAccess();

        private ListIndexMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            return Collections.emptyMap();
        }
    }

    private static class CollectionIdMappingAccess
    implements BasicMappingAccess {
        private static final CollectionIdMappingAccess INSTANCE = new CollectionIdMappingAccess();

        private CollectionIdMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            CollectionIdType customType = (CollectionIdType)attribute.locateAnnotationUsage(CollectionIdType.class, context);
            return customType == null ? null : customType.value();
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            CollectionIdType customType = (CollectionIdType)attribute.locateAnnotationUsage(CollectionIdType.class, context);
            return customType == null ? null : AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }

    private static class MapKeyMappingAccess
    implements BasicMappingAccess {
        private static final MapKeyMappingAccess INSTANCE = new MapKeyMappingAccess();

        private MapKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            MapKeyType customType = (MapKeyType)attribute.locateAnnotationUsage(MapKeyType.class, context);
            return customType == null ? null : customType.value();
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            MapKeyType customType = (MapKeyType)attribute.locateAnnotationUsage(MapKeyType.class, context);
            return customType == null ? null : AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }

    private static class AnyKeyMappingAccess
    implements BasicMappingAccess {
        private static final AnyKeyMappingAccess INSTANCE = new AnyKeyMappingAccess();

        private AnyKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            return Collections.emptyMap();
        }
    }

    private static class AnyDiscriminatorMappingAccess
    implements BasicMappingAccess {
        private static final AnyDiscriminatorMappingAccess INSTANCE = new AnyDiscriminatorMappingAccess();

        private AnyDiscriminatorMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            return Collections.emptyMap();
        }
    }

    private static class ValueMappingAccess
    implements BasicMappingAccess {
        private static final ValueMappingAccess INSTANCE = new ValueMappingAccess();

        private ValueMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attribute, ModelsContext context) {
            Type customType = (Type)attribute.locateAnnotationUsage(Type.class, context);
            return customType == null ? null : customType.value();
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attribute, ModelsContext context) {
            Type customType = (Type)attribute.locateAnnotationUsage(Type.class, context);
            return customType == null ? null : AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }
}

