/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class RemoveCountFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<RemoveCountFunction> EXTERNALIZER = new Externalizer();
    private final long count;
    private final V element;

    public RemoveCountFunction(long count, V element) {
        this.count = count;
        this.element = element;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket prevBucket = (ListBucket)existing.get();
            ListBucket.ListBucketResult<Long, V> result = prevBucket.remove(this.count, this.element);
            if (result.bucket().isEmpty()) {
                entryView.remove();
                return result.result();
            }
            entryView.set(result.bucket(), new MetaParam.Writable[0]);
            return result.result();
        }
        return 0L;
    }

    private static class Externalizer
    implements AdvancedExternalizer<RemoveCountFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends RemoveCountFunction>> getTypeClasses() {
            return Collections.singleton(RemoveCountFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.REMOVE_COUNT_FUNCTION;
        }

        public void writeObject(ObjectOutput output, RemoveCountFunction object) throws IOException {
            output.writeLong(object.count);
            output.writeObject(object.element);
        }

        public RemoveCountFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveCountFunction(input.readLong(), input.readObject());
        }
    }
}

