/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.merge;

import com.intellij.diff.merge.LangSpecificMergeContext;
import com.intellij.diff.util.ThreeSide;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.diff.util.AffectedChangeInfo;
import com.intellij.lang.properties.diff.util.AffectedChangeInfoKt;
import com.intellij.lang.properties.diff.util.DiffTextRangeWithData;
import com.intellij.lang.properties.merge.data.PropertyInfo;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder;", "", "sideContentList", "", "Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder$ThreeSideConflictInfo;", "<init>", "(Ljava/util/List;)V", "conflictToPropertiesMap", "", "", "", "Lcom/intellij/lang/properties/merge/data/PropertyInfo;", "Lcom/intellij/lang/properties/merge/ConflictToPropertiesMap;", "side", "Lcom/intellij/diff/util/ThreeSide;", "rangeList", "Lcom/intellij/openapi/util/TextRange;", "keySet", "", "Companion", "ThreeSideConflictInfo", "intellij.properties.backend"})
public final class ThreeSideConflictInfoHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ThreeSideConflictInfo> sideContentList;

    public ThreeSideConflictInfoHolder(@NotNull List<ThreeSideConflictInfo> sideContentList) {
        Intrinsics.checkNotNullParameter(sideContentList, (String)"sideContentList");
        this.sideContentList = sideContentList;
    }

    @NotNull
    public final Map<Integer, Map<String, PropertyInfo>> conflictToPropertiesMap(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.sideContentList.get(side.getIndex()).getConflictToPropertiesMap();
    }

    @NotNull
    public final List<TextRange> rangeList(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.sideContentList.get(side.getIndex()).getRangeList();
    }

    @NotNull
    public final Set<String> keySet(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.sideContentList.get(side.getIndex()).getKeySet();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002JD\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u000f\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder;", "context", "Lcom/intellij/diff/merge/LangSpecificMergeContext;", "findPropertyKeys", "", "", "propertyList", "", "Lcom/intellij/lang/properties/IProperty;", "findModifiedProperties", "", "", "Lcom/intellij/lang/properties/merge/data/PropertyInfo;", "Lcom/intellij/lang/properties/merge/ConflictToPropertiesMap;", "rangeList", "Lcom/intellij/openapi/util/TextRange;", "intellij.properties.backend"})
    @SourceDebugExtension(value={"SMAP\nThreeSideConflictInfoHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreeSideConflictInfoHolder.kt\ncom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n1563#2:88\n1634#2,3:89\n1563#2:92\n1634#2,3:93\n1563#2:96\n1634#2,3:97\n1374#2:100\n1460#2,2:101\n1563#2:103\n1634#2,3:104\n1462#2,3:107\n1491#2:110\n1516#2,3:111\n1519#2,3:121\n1252#2,2:126\n1193#2,2:128\n1267#2,4:130\n1255#2:134\n382#3,7:114\n463#3:124\n413#3:125\n*S KotlinDebug\n*F\n+ 1 ThreeSideConflictInfoHolder.kt\ncom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder$Companion\n*L\n27#1:88\n27#1:89,3\n43#1:92\n43#1:93,3\n57#1:96\n57#1:97,3\n63#1:100\n63#1:101,2\n64#1:103\n64#1:104,3\n63#1:107,3\n73#1:110\n73#1:111,3\n73#1:121,3\n73#1:126,2\n74#1:128,2\n74#1:130,4\n73#1:134\n73#1:114,7\n73#1:124\n73#1:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ThreeSideConflictInfoHolder create(@NotNull LangSpecificMergeContext context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$map$iv = (Iterable)ThreeSide.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map<Integer, Map<String, PropertyInfo>> propertyMap;
                Set<String> propertyKeySet;
                List propertyList;
                void side;
                ThreeSide threeSide = (ThreeSide)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PsiFile file = context.file((ThreeSide)side);
                List rangeList = context.lineRanges((ThreeSide)side);
                if (!(file instanceof PropertiesFile)) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)((PropertiesFile)file).getProperties(), (String)"getProperties(...)");
                if (Companion.findModifiedProperties(propertyList, rangeList) == null) {
                    return null;
                }
                if (Companion.findPropertyKeys(propertyList) == null) {
                    return null;
                }
                collection.add(new ThreeSideConflictInfo(rangeList, propertyKeySet, propertyMap));
            }
            List list = (List)destination$iv$iv;
            return new ThreeSideConflictInfoHolder(list);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> findPropertyKeys(List<? extends IProperty> propertyList) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = propertyList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String key;
                void property;
                IProperty iProperty = (IProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(property instanceof Property)) {
                    return null;
                }
                if (((Property)property).getUnescapedKey() == null) {
                    return null;
                }
                collection.add(key);
            }
            List keyList = (List)destination$iv$iv;
            Set keySet = CollectionsKt.toSet((Iterable)keyList);
            if (keySet.size() != keyList.size()) {
                return null;
            }
            return keySet;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Integer, Map<String, PropertyInfo>> findModifiedProperties(List<? extends IProperty> propertyList, List<? extends TextRange> rangeList) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            Iterable list$iv$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = propertyList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void property;
                IProperty iProperty = (IProperty)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                if (!(property instanceof Property)) {
                    return null;
                }
                TextRange textRange = ((Property)property).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                object.add(new DiffTextRangeWithData(textRange, property));
            }
            List propertyRangeList = (List)destination$iv$iv;
            $this$map$iv = AffectedChangeInfoKt.findAffectedChanges(rangeList, propertyRangeList);
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                AffectedChangeInfo changeInfo = (AffectedChangeInfo)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = changeInfo.getFragmentIndexList();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    String value;
                    String key;
                    void index;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Object property = changeInfo.getData();
                    if (!(property instanceof Property)) {
                        return null;
                    }
                    if (((Property)property).getKey() == null) {
                        return null;
                    }
                    if (((Property)property).getValue() == null) {
                        return null;
                    }
                    String comment = ((Property)property).getDocCommentText();
                    PsiElement borderElement = PropertyImpl.getEdgeOfProperty((Property)((Property)property));
                    Integer n2 = (int)index;
                    Intrinsics.checkNotNull((Object)borderElement);
                    collection.add(TuplesKt.to((Object)n2, (Object)new PropertyInfo(borderElement, key, value, comment)));
                }
                list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$flatMapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                key$iv$iv = ((Number)it.getFirst()).intValue();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$associateTo$iv$iv;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = object3;
                boolean bl4 = false;
                List list = (List)entry.getValue();
                Iterable $this$associate$iv = list;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable bl2 = $this$associate$iv;
                Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv3;
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl5 = false;
                    PropertyInfo info = (PropertyInfo)pair.component2();
                    pair = TuplesKt.to((Object)PropertyImpl.unescape((String)info.getKey()), (Object)info);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map map = destination$iv$iv3;
                object.put(k, map);
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\"\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\t0\tj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J%\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\t0\tj\u0002`\fH\u00c6\u0003JO\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\t0\tj\u0002`\fH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\t0\tj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder$ThreeSideConflictInfo;", "", "rangeList", "", "Lcom/intellij/openapi/util/TextRange;", "keySet", "", "", "conflictToPropertiesMap", "", "", "Lcom/intellij/lang/properties/merge/data/PropertyInfo;", "Lcom/intellij/lang/properties/merge/ConflictToPropertiesMap;", "<init>", "(Ljava/util/List;Ljava/util/Set;Ljava/util/Map;)V", "getRangeList", "()Ljava/util/List;", "getKeySet", "()Ljava/util/Set;", "getConflictToPropertiesMap", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.properties.backend"})
    public static final class ThreeSideConflictInfo {
        @NotNull
        private final List<TextRange> rangeList;
        @NotNull
        private final Set<String> keySet;
        @NotNull
        private final Map<Integer, Map<String, PropertyInfo>> conflictToPropertiesMap;

        public ThreeSideConflictInfo(@NotNull List<? extends TextRange> rangeList, @NotNull Set<String> keySet, @NotNull Map<Integer, ? extends Map<String, PropertyInfo>> conflictToPropertiesMap) {
            Intrinsics.checkNotNullParameter(rangeList, (String)"rangeList");
            Intrinsics.checkNotNullParameter(keySet, (String)"keySet");
            Intrinsics.checkNotNullParameter(conflictToPropertiesMap, (String)"conflictToPropertiesMap");
            this.rangeList = rangeList;
            this.keySet = keySet;
            this.conflictToPropertiesMap = conflictToPropertiesMap;
        }

        @NotNull
        public final List<TextRange> getRangeList() {
            return this.rangeList;
        }

        @NotNull
        public final Set<String> getKeySet() {
            return this.keySet;
        }

        @NotNull
        public final Map<Integer, Map<String, PropertyInfo>> getConflictToPropertiesMap() {
            return this.conflictToPropertiesMap;
        }

        @NotNull
        public final List<TextRange> component1() {
            return this.rangeList;
        }

        @NotNull
        public final Set<String> component2() {
            return this.keySet;
        }

        @NotNull
        public final Map<Integer, Map<String, PropertyInfo>> component3() {
            return this.conflictToPropertiesMap;
        }

        @NotNull
        public final ThreeSideConflictInfo copy(@NotNull List<? extends TextRange> rangeList, @NotNull Set<String> keySet, @NotNull Map<Integer, ? extends Map<String, PropertyInfo>> conflictToPropertiesMap) {
            Intrinsics.checkNotNullParameter(rangeList, (String)"rangeList");
            Intrinsics.checkNotNullParameter(keySet, (String)"keySet");
            Intrinsics.checkNotNullParameter(conflictToPropertiesMap, (String)"conflictToPropertiesMap");
            return new ThreeSideConflictInfo(rangeList, keySet, conflictToPropertiesMap);
        }

        public static /* synthetic */ ThreeSideConflictInfo copy$default(ThreeSideConflictInfo threeSideConflictInfo, List list, Set set, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                list = threeSideConflictInfo.rangeList;
            }
            if ((n & 2) != 0) {
                set = threeSideConflictInfo.keySet;
            }
            if ((n & 4) != 0) {
                map = threeSideConflictInfo.conflictToPropertiesMap;
            }
            return threeSideConflictInfo.copy(list, set, map);
        }

        @NotNull
        public String toString() {
            return "ThreeSideConflictInfo(rangeList=" + this.rangeList + ", keySet=" + this.keySet + ", conflictToPropertiesMap=" + this.conflictToPropertiesMap + ")";
        }

        public int hashCode() {
            int result = ((Object)this.rangeList).hashCode();
            result = result * 31 + ((Object)this.keySet).hashCode();
            result = result * 31 + ((Object)this.conflictToPropertiesMap).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreeSideConflictInfo)) {
                return false;
            }
            ThreeSideConflictInfo threeSideConflictInfo = (ThreeSideConflictInfo)other;
            if (!Intrinsics.areEqual(this.rangeList, threeSideConflictInfo.rangeList)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.keySet, threeSideConflictInfo.keySet)) {
                return false;
            }
            return Intrinsics.areEqual(this.conflictToPropertiesMap, threeSideConflictInfo.conflictToPropertiesMap);
        }
    }
}

